/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util.crypt.impl;

import com.identity4j.util.crypt.EncoderException;
import com.identity4j.util.crypt.impl.AbstractEncoder;
import com.identity4j.util.unix.MD5Crypt;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class UnixMD5Encoder
extends AbstractEncoder {
    public static final String ID = "unix-md5";
    private final String saltPrefix;

    public UnixMD5Encoder() {
        this(ID, "$1$");
    }

    public UnixMD5Encoder(String id, String saltPrefix) {
        super(id);
        this.saltPrefix = saltPrefix;
    }

    @Override
    public boolean match(byte[] encodedData, byte[] unencodedData, byte[] passphrase, String charset) throws EncoderException {
        try {
            if (!this.isOfType(encodedData, charset)) {
                throw new EncoderException("Encoded data is not in Unix MD5 crypt format");
            }
            String encoded = new String(encodedData, charset);
            if (encoded.equals("*")) {
                return false;
            }
            if (encoded.startsWith("!")) {
                return false;
            }
            int sl = this.saltPrefix.length();
            int idx = encoded.indexOf(36, sl);
            if (idx == -1) {
                throw new EncoderException("Expected end of salt character $");
            }
            String encsalt = encoded.substring(0, idx);
            return Arrays.equals(this.encode(unencodedData, encsalt.getBytes(charset), passphrase, charset), encodedData);
        }
        catch (UnsupportedEncodingException e) {
            throw new EncoderException(e);
        }
    }

    @Override
    public boolean isOfType(byte[] encodedBytes, String charset) {
        try {
            return new String(encodedBytes, charset).startsWith(this.saltPrefix);
        }
        catch (UnsupportedEncodingException e) {
            throw new EncoderException(e);
        }
    }

    @Override
    public byte[] encode(byte[] toEncode, byte[] salt, byte[] passphrase, String charset) throws EncoderException {
        try {
            if (salt == null) {
                return MD5Crypt.md5Crypt(new String(toEncode, charset), charset).getBytes(charset);
            }
            String saltString = new String(salt, charset);
            if (saltString.length() < 2) {
                throw new EncoderException("Salt must be at least 2 characters .");
            }
            String crypt = MD5Crypt.crypt_md5(toEncode, saltString, this.saltPrefix);
            return crypt.getBytes(charset);
        }
        catch (Exception e) {
            throw new EncoderException(e);
        }
    }
}

