/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util.crypt.nss;

import com.identity4j.util.crypt.EncoderException;
import com.identity4j.util.crypt.impl.AbstractEncoder;
import com.identity4j.util.crypt.nss.NssTokenDatabase;

public class NSSEncoder
extends AbstractEncoder {
    public static final String ID = "nss";
    private NssTokenDatabase tokenDatabase;

    public NSSEncoder(NssTokenDatabase tokenDatabase) {
        this(ID, tokenDatabase);
    }

    protected NSSEncoder(String id, NssTokenDatabase tokenDatabase) {
        super(id);
        this.tokenDatabase = tokenDatabase;
    }

    @Override
    public byte[] decode(byte[] toDecode, byte[] salt, byte[] passphrase, String charset) throws EncoderException {
        if (salt != null) {
            throw new IllegalArgumentException("FIPS encoder does not suppport salt.");
        }
        if (passphrase != null) {
            throw new IllegalArgumentException("FIPS encoder does not suppport passphrase.");
        }
        try {
            return this.tokenDatabase.decrypt(new String(toDecode, charset)).getBytes(charset);
        }
        catch (Exception e) {
            throw new EncoderException(e);
        }
    }

    @Override
    public byte[] encode(byte[] toEncode, byte[] salt, byte[] passphrase, String charset) throws EncoderException {
        if (salt != null) {
            throw new IllegalArgumentException("FIPS encoder does not suppport salt.");
        }
        if (passphrase != null) {
            throw new IllegalArgumentException("FIPS encoder does not suppport passphrase.");
        }
        try {
            return this.tokenDatabase.encrypt(new String(toEncode, charset)).getBytes(charset);
        }
        catch (Exception e) {
            throw new EncoderException(e);
        }
    }
}

