/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util.crypt.nss;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NssTokenDatabase {
    private static NssTokenDatabase instance;
    static Log log;
    private String dbPassword;
    private KeyStore keystore;
    private Provider cryptoProvider;
    private byte[] noise;
    private File dbDir;
    private File privateDir;
    private byte[] passphrase;
    private String keyName;
    private boolean fipsMode;
    private Mode mode;

    public static NssTokenDatabase getInstance() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, InterruptedException {
        if (instance == null) {
            throw new IllegalStateException("State NssTokenDatabase not initialized, please construct an instance once to register an instance.");
        }
        return instance;
    }

    public NssTokenDatabase() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, InterruptedException {
        this(new File(NssTokenDatabase.getNssConfigurationDirectory()));
    }

    public static String getNssConfigurationDirectory() {
        String path = System.getProperty("identity4j.nss.conf");
        if (path == null) {
            path = System.getProperty("nervepoint.conf");
        }
        if (path == null) {
            path = System.getProperty("user.home") + File.separator + ".nss";
        }
        return path;
    }

    public NssTokenDatabase(File dbDir) {
        this(dbDir, null, null);
    }

    public NssTokenDatabase(byte[] noise, byte[] passphrase) {
        this(new File(NssTokenDatabase.getNssConfigurationDirectory()), noise, passphrase);
    }

    public NssTokenDatabase(File dbDir, byte[] noise, byte[] passphrase) {
        instance = this;
        this.keyName = "nam";
        this.fipsMode = true;
        this.mode = Mode.valueOf(System.getProperty("hypersocket.nss.mode", Mode.AUTO.name()));
        this.noise = noise;
        this.passphrase = passphrase;
        this.dbDir = dbDir;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public boolean isFipsMode() {
        return this.fipsMode;
    }

    public void setFipsMode(boolean fipsMode) {
        if (this.keystore != null) {
            throw new IllegalStateException("FIPS mode cannot be changed if the keystore is started.");
        }
        this.fipsMode = fipsMode;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public Enumeration<String> keynames() throws KeyStoreException {
        return this.keystore.aliases();
    }

    public void start() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        if (!this.dbDir.exists() && !this.dbDir.mkdirs()) {
            throw new IllegalStateException(String.format("Could not create database directory %s.  Please ensure user %s has permissions to write to the parent directory.", this.dbDir, System.getProperty("user.name")));
        }
        this.privateDir = new File(this.dbDir, ".private");
        if (!this.privateDir.exists() && !this.privateDir.mkdirs()) {
            throw new IllegalStateException(String.format("Could not create database private directory %s.  Please ensure user %s has permissions to write to the parent directory.", this.privateDir, System.getProperty("user.name")));
        }
        File keystoreFile = new File(this.privateDir, ".key");
        if (!keystoreFile.exists()) {
            this.createDatabase(keystoreFile);
        }
        this.openDatabase(keystoreFile);
    }

    public String encrypt(String toEncrypt) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, UnrecoverableKeyException, KeyStoreException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        if (this.privateDir == null) {
            throw new IllegalStateException(String.format("%s must be started.", NssTokenDatabase.class.getName()));
        }
        Cipher c = Cipher.getInstance("RSA/ECB/PKCS1Padding", this.cryptoProvider);
        c.init(1, this.keystore.getKey(this.keyName, null));
        return Base64.encodeBase64String((byte[])c.doFinal(toEncrypt.getBytes("UTF-8")));
    }

    public String decrypt(String toDecrypt) throws InvalidKeyException, KeyStoreException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, UnsupportedEncodingException {
        if (this.privateDir == null) {
            throw new IllegalStateException(String.format("%s must be started.", NssTokenDatabase.class.getName()));
        }
        Cipher c = Cipher.getInstance("RSA/ECB/PKCS1Padding", this.cryptoProvider);
        c.init(2, this.keystore.getCertificate(this.keyName));
        return new String(c.doFinal(Base64.decodeBase64((String)toDecrypt)), "UTF-8");
    }

    public static String generateString(int length) {
        String characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        char[] text = new char[length];
        SecureRandom rng = new SecureRandom();
        for (int i = 0; i < length; ++i) {
            text[i] = characters.charAt(rng.nextInt(characters.length()));
        }
        return new String(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void openDatabase(File keyFile) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        libFolder64bit = new File("/usr/lib/x86_64-linux-gnu");
        filename = "nss.cfg";
        if ("64".equals(System.getProperty("sun.arch.data.model")) || libFolder64bit.exists()) {
            filename = "nss64.cfg";
        }
        actualMode = this.getActualMode();
        configFile = new File(this.dbDir, filename);
        if (!configFile.exists()) {
            configFile = File.createTempFile("id4j", filename);
            configFile.deleteOnExit();
            pw = new PrintWriter(configFile);
            try {
                if (this.fipsMode) {
                    if (actualMode == Mode.SQL) {
                        pw.println("name = NSScrypto");
                    } else {
                        pw.println("name = NSSfips");
                        pw.println("nssModule = fips");
                    }
                    pw.println("nssDbMode = readWrite");
                    pw.println("nssSecmodDirectory = " + (this.fipsMode != false && actualMode == Mode.SQL ? "sql:" : "") + this.privateDir.getAbsolutePath());
                } else {
                    pw.println("name = NSScrypto");
                    pw.println("nssDbMode = noDb");
                }
                pw.println("attributes = compatibility");
                if (!System.getProperty("identity4j.nss.ignoreMultipleInitialisation", "false").equals("true")) ** GOTO lbl73
                pw.println("handleStartupErrors = ignoreMultipleInitialisation");
            }
            finally {
                pw.close();
            }
        } else {
            p = new Properties();
            fin = new FileInputStream(configFile);
            try {
                p.load(fin);
            }
            finally {
                fin.close();
            }
            changed = 0;
            if (this.fipsMode && !"fips".equals(p.getProperty("nssModule"))) {
                p.setProperty("nssModule", "fips");
                p.setProperty("name", "NSSfips");
                p.setProperty("nssSecmodDirectory", this.privateDir.getAbsolutePath());
                p.setProperty("nssDbMode", "readWrite");
                p.remove("attributes");
                changed = 1;
            } else if (!this.fipsMode && "fips".equals(p.getProperty("nssModule"))) {
                p.remove("nssModule");
                p.remove("nssSecmodDirectory");
                p.setProperty("name", "NSScrypto");
                p.setProperty("attributes", "compatibility");
                p.setProperty("nssDbMode", "noDb");
                changed = 1;
            }
            if (changed != 0) {
                fos = new FileOutputStream(configFile);
                try {
                    p.store(fos, "Identity4J NSS configuration");
                }
                finally {
                    fos.close();
                }
            }
        }
        for (Provider p : Security.getProviders()) {
            NssTokenDatabase.log.info((Object)p.getName());
        }
        try {
            clz = Class.forName("sun.security.pkcs11.SunPKCS11");
            this.cryptoProvider = Security.getProvider("SunPKCS11");
            configPath = configFile.getAbsolutePath();
            if (this.cryptoProvider == null) {
                try {
                    constructor = clz.getConstructor(new Class[]{String.class});
                    constructor.setAccessible(true);
                    this.cryptoProvider = (Provider)constructor.newInstance(new Object[]{configPath});
                }
                catch (NoSuchMethodException | InvocationTargetException nsme) {
                    constructor = clz.getConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    this.cryptoProvider = (Provider)constructor.newInstance(new Object[0]);
                    this.cryptoProvider = (Provider)this.cryptoProvider.getClass().getMethod("configure", new Class[]{String.class}).invoke((Object)this.cryptoProvider, new Object[]{configPath});
                }
            } else {
                this.cryptoProvider = (Provider)this.cryptoProvider.getClass().getMethod("configure", new Class[]{String.class}).invoke((Object)this.cryptoProvider, new Object[]{configPath});
            }
            fin = new FileInputStream(keyFile);
            try {
                this.dbPassword = IOUtils.toString((InputStream)fin, (String)"US-ASCII");
            }
            finally {
                fin.close();
            }
            nssDBPassword = this.dbPassword.toCharArray();
            this.keystore = KeyStore.getInstance("PKCS11", this.cryptoProvider);
            this.keystore.load(null, nssDBPassword);
        }
        catch (ClassNotFoundException e) {
            throw new KeyStoreException("No SunPKCS11 provider on classpath.", e);
        }
        catch (InstantiationException e) {
            throw new KeyStoreException("SunPKCS11 could not be instantiated.", e);
        }
        catch (InvocationTargetException e) {
            throw new KeyStoreException("SunPKCS11 could not be started.", e);
        }
        catch (NoSuchMethodException e) {
            throw new KeyStoreException("SunPKCS11 did not conform to expected API.", e);
        }
        catch (IllegalAccessException e) {
            throw new KeyStoreException("SunPKCS11 could not be accessed.", e);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (SecurityException e) {
            throw e;
        }
    }

    public List<String> getSecretKeyNames() throws IOException {
        try {
            ArrayList<String> keyNames = new ArrayList<String>();
            Enumeration<String> en = this.keystore.aliases();
            while (en.hasMoreElements()) {
                keyNames.add(en.nextElement());
            }
            return keyNames;
        }
        catch (KeyStoreException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public List<SecretKey> getSecretKeys() throws IOException {
        try {
            ArrayList<SecretKey> keys = new ArrayList<SecretKey>();
            Enumeration<String> en = this.keystore.aliases();
            while (en.hasMoreElements()) {
                keys.add((SecretKey)this.keystore.getKey(en.nextElement(), this.dbPassword.toCharArray()));
            }
            return keys;
        }
        catch (UnrecoverableKeyException e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (KeyStoreException e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public void createSecretKey(String reference) throws IOException {
        try {
            KeyGenerator kg = KeyGenerator.getInstance("AES", this.cryptoProvider);
            kg.init(256);
            SecretKey skey = kg.generateKey();
            this.keystore.setEntry(reference, new KeyStore.SecretKeyEntry(skey), new KeyStore.PasswordProtection(this.dbPassword.toCharArray()));
            this.keystore.store(null, this.dbPassword.toCharArray());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (KeyStoreException e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (CertificateException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public SecretKey getSecretKey(String reference) throws IOException {
        try {
            return (SecretKey)this.keystore.getKey(reference, this.dbPassword.toCharArray());
        }
        catch (UnrecoverableKeyException e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (KeyStoreException e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDatabase(File keyFile) throws IOException, KeyStoreException {
        if (this.check("certutil") != 1) {
            throw new IllegalStateException("Could not detect certutil. Please ensure this is installed (for example, on Debian this would be the libnss3-tools package.");
        }
        if (this.check("modutil") != 1) {
            throw new IllegalStateException("Could not detect modutil. Please ensure this is installed (for example, on Debian this would be the libnss3-tools package.");
        }
        try (FileOutputStream o = new FileOutputStream(keyFile);){
            if (this.passphrase == null) {
                String password = new BigInteger(130, new SecureRandom()).toString(32);
                o.write(password.getBytes("US-ASCII"));
            } else {
                o.write(this.passphrase);
            }
            o.flush();
        }
        File noiseFile = File.createTempFile("id4jnoise", ".dat");
        noiseFile.deleteOnExit();
        boolean ok = false;
        String dbPrefix = "";
        dbPrefix = this.isSQLMode() ? "sql:" : "dbm:";
        try {
            String[] certCmd;
            String[] makeFips;
            try (FileOutputStream out = new FileOutputStream(noiseFile);){
                if (this.noise == null) {
                    File random = new File("/dev/urandom");
                    try (FileInputStream in = new FileInputStream(random);){
                        for (int i = 0; i < 128; ++i) {
                            out.write(in.read());
                        }
                    }
                } else {
                    out.write(this.noise);
                }
                out.flush();
            }
            String db = this.privateDir.getAbsolutePath();
            String[] createCmd = new String[]{"certutil", "-N", "-d", dbPrefix + db, "-f", db + "/.key"};
            if (this.exec(false, createCmd) != 0) {
                throw new IllegalStateException("Failed to create new private key for FIPS mode, check log output.");
            }
            if (this.fipsMode && this.isDBMMode() && this.exec(false, makeFips = new String[]{"modutil", "-fips", "true", "-dbdir", dbPrefix + db, "-force"}) != 0) {
                log.error((Object)"Failed to enable FIPS mode, check log output.");
            }
            if (this.isSQLMode()) {
                File secmod = new File(this.privateDir, "secmod.db");
                secmod.delete();
                secmod.createNewFile();
            }
            if (this.exec(false, certCmd = new String[]{"certutil", "-S", "-s", "CN=Access Manager", "-n", this.keyName, "-x", "-t", "CT,C,C", "-v", "120", "-m", "1234", "-d", dbPrefix + db, "-z", noiseFile.getAbsolutePath(), "-f", db + "/.key", "-g", "2048"}) != 0) {
                throw new IllegalStateException("Failed to create certificate, check log output.");
            }
            this.exec(false, "chmod", "400", keyFile.getAbsolutePath());
            this.exec(false, "chmod", "500", this.privateDir.getAbsolutePath());
            ok = true;
        }
        finally {
            noiseFile.delete();
            if (!ok) {
                FileUtils.deleteDirectory((File)this.privateDir);
            }
        }
    }

    protected boolean isDBMMode() {
        return this.mode == Mode.DBM || this.mode == Mode.AUTO;
    }

    protected boolean isSQLMode() {
        return this.mode == Mode.SQL;
    }

    protected Mode getActualMode() {
        File secmod = new File(this.privateDir, "secmod.db");
        if (secmod.exists() && secmod.length() > 0L) {
            return Mode.DBM;
        }
        return Mode.SQL;
    }

    private int check(String ... cmd) {
        try {
            return this.exec(true, cmd);
        }
        catch (IOException ioe) {
            return -1;
        }
    }

    private int exec(boolean quiet, String ... cmd) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.directory(this.dbDir);
        pb.redirectErrorStream(true);
        Process proc = pb.start();
        if (quiet) {
            IOUtils.copy((InputStream)proc.getInputStream(), (OutputStream)new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                }
            });
        } else {
            IOUtils.copy((InputStream)proc.getInputStream(), (OutputStream)System.out);
        }
        try {
            int ret = proc.waitFor();
            if (ret != 0 && !quiet) {
                log.warn((Object)String.format("%s failed with exit code %d", cmd[0], ret));
            }
            return ret;
        }
        catch (InterruptedException ie) {
            throw new IOException(ie);
        }
    }

    static {
        log = LogFactory.getLog(NssTokenDatabase.class);
    }

    public static enum Mode {
        SQL,
        DBM,
        AUTO;

    }
}

