/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util.expect;

import com.identity4j.util.expect.DefaultExpectMatcher;
import com.identity4j.util.expect.ExpectMatcher;
import com.identity4j.util.expect.ExpectTimeoutException;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Expect {
    protected List<ExpectMatcher> matchers = new ArrayList<ExpectMatcher>();
    protected BufferedInputStream in;
    private OutputStream out;
    private String eol;
    private boolean open = true;
    static Log log = LogFactory.getLog(Expect.class);

    public Expect() {
        this(null, null, null, "\r");
    }

    public Expect(ExpectMatcher matcher) {
        this(matcher, null, null, "\r");
    }

    public Expect(InputStream in, OutputStream out) {
        this(null, in, out, "\r");
    }

    public Expect(ExpectMatcher matcher, InputStream in, OutputStream out) {
        this(matcher, in, out, "\r");
    }

    public Expect(ExpectMatcher matcher, InputStream in, OutputStream out, String eol) {
        if (matcher != null) {
            this.matchers.add(matcher);
        }
        if (!(matcher instanceof DefaultExpectMatcher)) {
            this.matchers.add(new DefaultExpectMatcher());
        }
        this.in = new BufferedInputStream(in);
        this.out = out;
        this.eol = eol;
    }

    protected boolean isOpen() {
        return this.open;
    }

    public void interrupt() throws IOException {
        this.type(new String(new char[]{'\u0003'}));
    }

    public synchronized void type(String string) throws IOException {
        this.write(string.getBytes());
    }

    public synchronized boolean expect(String pattern) throws ExpectTimeoutException, IOException {
        return this.expect(pattern, false, 0L, 0L);
    }

    public synchronized boolean expect(String pattern, boolean consumeRemainingLine) throws ExpectTimeoutException, IOException {
        return this.expect(pattern, consumeRemainingLine, 0L, 0L);
    }

    public synchronized boolean expect(String pattern, long timeout) throws ExpectTimeoutException, IOException {
        return this.expect(pattern, false, timeout, 0L);
    }

    public synchronized boolean expect(String pattern, boolean consumeRemainingLine, long timeout) throws ExpectTimeoutException, IOException {
        return this.expect(pattern, consumeRemainingLine, timeout, 0L);
    }

    public synchronized boolean expectNextLine(String pattern) throws ExpectTimeoutException, IOException {
        return this.expect(pattern, false, 0L, 1L);
    }

    public synchronized boolean expectNextLine(String pattern, boolean consumeRemainingLine) throws ExpectTimeoutException, IOException {
        return this.expect(pattern, consumeRemainingLine, 0L, 1L);
    }

    public synchronized boolean expectNextLine(String pattern, boolean consumeRemainingLine, long timeout) throws ExpectTimeoutException, IOException {
        return this.expect(pattern, consumeRemainingLine, timeout, 1L);
    }

    public synchronized boolean expect(String pattern, boolean consumeRemainingLine, long timeout, long maxLines) throws ExpectTimeoutException, IOException {
        try {
            String chat = this.chat(pattern, consumeRemainingLine, timeout, maxLines, false);
            boolean matched = chat != null;
            return matched;
        }
        catch (EOFException e) {
            return false;
        }
    }

    public synchronized boolean maybeExpectNextLine(String pattern, boolean consumeRemainingLine, long timeout) throws ExpectTimeoutException, IOException {
        return this.maybeExpect(pattern, consumeRemainingLine, timeout, 1L);
    }

    public synchronized boolean maybeExpectNextLine(String pattern, boolean consumeRemainingLine) throws ExpectTimeoutException, IOException {
        return this.maybeExpect(pattern, consumeRemainingLine, 0L, 1L);
    }

    public synchronized boolean maybeExpectNextLine(String pattern) throws ExpectTimeoutException, IOException {
        return this.maybeExpect(pattern, false, 0L, 1L);
    }

    public synchronized boolean maybeExpect(String pattern, boolean consumeRemainingLine, long timeout) throws ExpectTimeoutException, IOException {
        return this.maybeExpect(pattern, consumeRemainingLine, timeout, 0L);
    }

    public synchronized boolean maybeExpect(String pattern, long timeout) throws ExpectTimeoutException, IOException {
        return this.maybeExpect(pattern, false, timeout, 0L);
    }

    public synchronized boolean maybeExpect(String pattern, boolean consumeRemainingLine) throws ExpectTimeoutException, IOException {
        return this.maybeExpect(pattern, consumeRemainingLine, 0L, 0L);
    }

    public synchronized boolean maybeExpect(String pattern) throws ExpectTimeoutException, IOException {
        return this.maybeExpect(pattern, false, 0L, 0L);
    }

    public synchronized boolean maybeExpect(String pattern, boolean consumeRemainingLine, long timeout, long maxLines) throws ExpectTimeoutException, IOException {
        this.in.mark(32768);
        try {
            boolean matched;
            String chat = this.chat(pattern, consumeRemainingLine, timeout, maxLines, false);
            boolean bl = matched = chat != null;
            if (!matched) {
                this.in.reset();
            }
            return matched;
        }
        catch (EOFException e) {
            this.in.reset();
            return false;
        }
        catch (ExpectTimeoutException e) {
            this.in.reset();
            return false;
        }
    }

    public synchronized String chat(String pattern, boolean consumeRemainingLine, long timeout, long maxLines, boolean ignoreEmptyLines) throws ExpectTimeoutException, IOException {
        this.checkIn();
        StringBuffer line = new StringBuffer();
        long time = System.currentTimeMillis();
        long lines = 0L;
        while (System.currentTimeMillis() - time < timeout || timeout == 0L) {
            try {
                if (maxLines > 0L && lines >= maxLines) {
                    return null;
                }
                int ch = this.read(timeout);
                if (ch == -1) {
                    if (line.length() > 0 && this.matches(line.toString(), pattern)) {
                        this.open = false;
                        return line.toString();
                    }
                    throw new EOFException();
                }
                if (ch == Integer.MIN_VALUE) continue;
                if (ch != 10 && ch != 13) {
                    line.append((char)ch);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Checking if '" + line + "' is '" + pattern + "'"));
                }
                if (this.matches(line.toString(), pattern)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Matched: [" + pattern + "] " + line.toString()));
                    }
                    if (consumeRemainingLine && ch != 10 && ch != -1) {
                        while (ch != 10 && ch != -1) {
                        }
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Matched shell output: " + line.toString()));
                    }
                    return line.toString();
                }
                if (ch != 10) continue;
                if (!ignoreEmptyLines) {
                    ++lines;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Unmatched shell output: " + line.toString()));
                }
                line.delete(0, line.length());
            }
            catch (IOException e) {
                this.open = false;
                throw e;
            }
        }
        throw new ExpectTimeoutException();
    }

    protected boolean matches(String line, String pattern) {
        for (ExpectMatcher m : this.matchers) {
            if (!m.matches(line, pattern)) continue;
            return true;
        }
        return false;
    }

    protected int read(long timeout) throws IOException, ExpectTimeoutException {
        long startTime = System.currentTimeMillis();
        try {
            if (timeout > 0L) {
                while (this.isOpen() && this.in.available() == 0 && System.currentTimeMillis() - startTime < timeout) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.in.available() == -1) {
                    return -1;
                }
                if (this.in.available() == 0) {
                    throw new ExpectTimeoutException();
                }
            }
            int read = this.in.read();
            return read;
        }
        catch (EOFException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Received EOF exception");
            }
            return -1;
        }
    }

    public synchronized String readLine() throws IOException, ExpectTimeoutException {
        return this.readLine(0L);
    }

    public synchronized String readLine(long timeout) throws IOException, ExpectTimeoutException {
        this.checkIn();
        StringBuffer line = new StringBuffer();
        long time = System.currentTimeMillis();
        do {
            int ch;
            if ((ch = this.read(timeout)) == -1 || ch == 10) {
                if (line.length() == 0 && ch == -1) {
                    this.open = false;
                    return null;
                }
                return line.toString();
            }
            if (ch == 10 || ch == 13) continue;
            line.append((char)ch);
        } while (System.currentTimeMillis() - time < timeout || timeout == 0L);
        throw new ExpectTimeoutException();
    }

    public static void main(String[] args) {
        System.out.println("passwd: ".matches("Re-enter new Password: |passwd: "));
    }

    public final InputStream getIn() {
        return this.in;
    }

    public final void setIn(InputStream in) {
        this.in = new BufferedInputStream(in);
    }

    public final OutputStream getOut() {
        return this.out;
    }

    public final void setOut(OutputStream out) {
        this.out = out;
    }

    public final String getEol() {
        return this.eol;
    }

    public final void setEol(String eol) {
        this.eol = eol;
    }

    public void typeAndReturn(String string) throws IOException {
        this.write((string + this.eol).getBytes());
    }

    public void write(byte[] bytes) throws IOException {
        this.checkOut();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Sending '" + new String(bytes) + "'"));
        }
        this.out.write(bytes);
        this.out.flush();
    }

    public void type(int b) throws IOException {
        this.write(new byte[]{(byte)b});
    }

    public void carriageReturn() throws IOException {
        this.write(this.eol.getBytes());
    }

    private void checkOut() throws IOException {
        if (this.out == null) {
            throw new IOException("No output stream set");
        }
    }

    private void checkIn() throws IOException {
        if (this.in == null) {
            throw new IOException("No input stream set");
        }
    }
}

