/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util.http.request;

import com.identity4j.util.http.Http;
import com.identity4j.util.http.HttpPair;
import com.identity4j.util.http.HttpProviderClient;
import com.identity4j.util.http.HttpResponse;
import java.net.URI;

public class HttpRequestHandler {
    public HttpResponse handleRequestGet(URI uri, HttpPair ... header) {
        return this.getClient(uri).get(this.getPathAndQuerry(uri), header);
    }

    public HttpResponse handleRequestPost(URI uri, String data, HttpPair ... header) {
        return this.getClient(uri).post(this.getPathAndQuerry(uri), data, header);
    }

    public HttpResponse handleRequestPatch(URI uri, String data, HttpPair ... headers) {
        return this.getClient(uri).patch(this.getPathAndQuerry(uri), data, headers);
    }

    public HttpResponse handleRequestPut(URI uri, String data, HttpPair ... headers) {
        return this.getClient(uri).put(this.getPathAndQuerry(uri), data, headers);
    }

    public HttpResponse handleRequestDelete(URI uri, HttpPair ... headers) {
        return this.getClient(uri).delete(this.getPathAndQuerry(uri), headers);
    }

    protected String getPath(URI uri) {
        return uri.getRawPath();
    }

    protected String getPathAndQuerry(URI uri) {
        if (uri.getRawQuery() == null) {
            return uri.getRawPath();
        }
        return uri.getRawPath() + "?" + uri.getRawQuery();
    }

    protected HttpProviderClient getClient(URI uri) {
        HttpProviderClient client = Http.getProvider().getClient(uri.getScheme() + "://" + uri.getHost() + (uri.getPort() == -1 ? "" : ":" + uri.getPort()), null, null, null);
        client.setConnectionRequestTimeout(90000);
        client.setConnectTimeout(90000);
        client.setSocketTimeout(90000);
        return client;
    }
}

