/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util.i18n;

import java.text.DateFormat;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Messages {
    private Messages() {
    }

    public static String getString(String bundle, String key, Object ... arguments) {
        return Messages.getString(null, Locale.getDefault(), bundle, key, arguments);
    }

    public static String getString(String bundle, Locale locale, String key, Object ... arguments) {
        return Messages.getString(null, locale, bundle, key, arguments);
    }

    public static String getString(ClassLoader classLoader, String bundle, String key, Object ... arguments) {
        return Messages.getString(classLoader, Locale.getDefault(), bundle, key, arguments);
    }

    public static String getString(ClassLoader classLoader, Locale locale, String bundle, String key, Object ... arguments) {
        try {
            ResourceBundle resource = Messages.getBundle(classLoader, locale, bundle);
            String localizedString = resource.getString(key);
            if (arguments == null || arguments.length == 0) {
                return localizedString;
            }
            localizedString = Messages.escapeQuotes(localizedString);
            MessageFormat messageFormat = new MessageFormat(localizedString);
            messageFormat.setLocale(locale);
            return messageFormat.format(Messages.formatParameters(arguments));
        }
        catch (MissingResourceException mre) {
            return "??" + (bundle == null ? "" : bundle + ":") + '!' + key + '!';
        }
    }

    public static ResourceBundle getBundle(Locale locale, String bundle) {
        return Messages.getBundle(null, locale, bundle);
    }

    public static ResourceBundle getBundle(ClassLoader classLoader, Locale locale, String bundle) {
        if (bundle == null) {
            return null;
        }
        if (!bundle.startsWith("i18n/")) {
            bundle = "i18n/" + bundle;
        }
        classLoader = Messages.determineClassLoader(classLoader);
        return ResourceBundle.getBundle(bundle, locale, classLoader);
    }

    protected static ClassLoader determineClassLoader(ClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            classLoader = Messages.class.getClassLoader();
        }
        return classLoader;
    }

    public static boolean isResourceExists(Locale locale, String bundle, String key, ClassLoader classLoader) {
        try {
            ResourceBundle resource = Messages.getBundle(classLoader, locale, bundle);
            resource.getString(key);
            return true;
        }
        catch (MissingResourceException mre) {
            return false;
        }
    }

    private static Object[] formatParameters(Object ... arguments) {
        ArrayList<Object> formatted = new ArrayList<Object>(arguments.length);
        for (Object arg : arguments) {
            if (arg instanceof Date) {
                formatted.add(DateFormat.getDateTimeInstance().format(arg));
                continue;
            }
            formatted.add(arg);
        }
        return formatted.toArray(new Object[formatted.size()]);
    }

    private static String escapeQuotes(String content) {
        if (content == null) {
            return null;
        }
        StringBuilder bui = new StringBuilder();
        int lastC = 32;
        for (int n : content.toCharArray()) {
            if (lastC > -1 && n == 39 && lastC != 39) {
                bui.append("'");
            }
            bui.append((char)n);
            lastC = n;
        }
        return bui.toString();
    }
}

