/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util.json;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.identity4j.util.json.JsonMapperException;
import java.io.IOException;
import java.util.Map;

public class JsonMapperService {
    private final ObjectMapper objectMapper = new ObjectMapper();

    private JsonMapperService() {
        this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public static JsonMapperService getInstance() {
        return LazyHolder.INSTANCE;
    }

    public <T> T getObject(Class<T> clazz, String json) {
        try {
            return (T)this.objectMapper.readValue(json, clazz);
        }
        catch (Exception e) {
            throw new JsonMapperException(e.getMessage(), e);
        }
    }

    public <T> T getObject(TypeReference<T> typeReference, String json) {
        try {
            return (T)this.objectMapper.readValue(json, typeReference);
        }
        catch (Exception e) {
            throw new JsonMapperException(e.getMessage(), e);
        }
    }

    public String getJson(Object object) throws IOException {
        return this.objectMapper.writeValueAsString(object);
    }

    public Object getJsonProperty(String json, String property) {
        try {
            return ((Map)this.objectMapper.readValue(json, Map.class)).get(property);
        }
        catch (Exception e) {
            throw new JsonMapperException(e.getMessage(), e);
        }
    }

    public <T> T convert(Object fromValue, Class<T> toType) {
        return (T)this.objectMapper.convertValue(fromValue, toType);
    }

    private static class LazyHolder {
        private static final JsonMapperService INSTANCE = new JsonMapperService();

        private LazyHolder() {
        }
    }
}

