/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util.passwords;

import com.identity4j.util.Util;
import com.identity4j.util.passwords.PasswordCharacteristics;
import java.util.HashMap;
import java.util.Map;

public class DefaultPasswordCharacteristics
implements PasswordCharacteristics {
    public static final char[] DEFAULT_SYMBOLS = new char[]{'!', '\"', '$', '\u00a3', '%', '^', '&', '*', '(', ')', '_', '-', '=', '+', '[', '{', ']', '}', ':', ';', '\'', '@', '~', '#', ',', '<', '.', '>', '|', '\\', '?'};
    private static final long serialVersionUID = 1L;
    private boolean dictionaryWordsAllowed = false;
    private int maximumSize = 255;
    private int historySize = 0;
    private int minimumSize = 8;
    private int minimumLowerCase = 0;
    private int minimumUpperCase = 0;
    private int minimumSymbols = 0;
    private int minimumDigits = 0;
    private int requiresMatches = 4;
    private float veryStrongFactor = 2.0f;
    private boolean containUsername;
    private Map<String, String> attributes = new HashMap<String, String>();
    private char[] symbols = DEFAULT_SYMBOLS;
    private boolean additionalAnalysis = false;
    private float minStrength;

    public DefaultPasswordCharacteristics() {
    }

    public DefaultPasswordCharacteristics(PasswordCharacteristics p) {
        this.dictionaryWordsAllowed = p.isDictionaryWordsAllowed();
        this.maximumSize = p.getMaximumSize();
        this.minimumSize = p.getMinimumSize();
        this.minimumLowerCase = p.getMinimumLowerCase();
        this.minimumUpperCase = p.getMinimumUpperCase();
        this.minimumSymbols = p.getMinimumSymbols();
        this.minimumDigits = p.getMinimumDigits();
        this.requiresMatches = p.getRequiredMatches();
        this.veryStrongFactor = p.getVeryStrongFactor();
        this.containUsername = p.isContainUsername();
        this.historySize = p.getHistorySize();
        this.symbols = p.getSymbols();
        this.attributes.putAll(p.getAttributes());
        this.additionalAnalysis = p.isAdditionalAnalysis();
        this.minStrength = p.getMinStrength();
    }

    @Override
    public float getMinStrength() {
        return this.minStrength;
    }

    public void setMinStrength(float minStrength) {
        this.minStrength = minStrength;
    }

    @Override
    public boolean isAdditionalAnalysis() {
        return this.additionalAnalysis;
    }

    public void setAdditionalAnalysis(boolean additionalAnalysis) {
        this.additionalAnalysis = additionalAnalysis;
    }

    @Override
    public int getHistorySize() {
        return this.historySize;
    }

    public void setHistorySize(int historySize) {
        this.historySize = historySize;
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Override
    public float getVeryStrongFactor() {
        return this.veryStrongFactor;
    }

    public void setVeryStrongFactor(float veryStrongFactor) {
        this.veryStrongFactor = veryStrongFactor;
    }

    @Override
    public char[] getSymbols() {
        return this.symbols;
    }

    public void setSymbols(char[] symbols) {
        this.symbols = symbols;
    }

    @Override
    public boolean isDictionaryWordsAllowed() {
        return this.dictionaryWordsAllowed;
    }

    public void setDictionaryWordsAllowed(boolean dictionaryWordsAllowed) {
        this.dictionaryWordsAllowed = dictionaryWordsAllowed;
    }

    @Override
    public int getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(int maximumSize) {
        this.maximumSize = maximumSize;
    }

    @Override
    public int getMinimumSize() {
        return this.minimumSize;
    }

    public void setMinimumSize(int minimumSize) {
        this.minimumSize = minimumSize;
    }

    @Override
    public int getMinimumLowerCase() {
        return this.minimumLowerCase;
    }

    public void setMinimumLowerCase(int minimumLowerCase) {
        this.minimumLowerCase = minimumLowerCase;
    }

    @Override
    public int getMinimumUpperCase() {
        return this.minimumUpperCase;
    }

    public void setMinimumUpperCase(int minimumUpperCase) {
        this.minimumUpperCase = minimumUpperCase;
    }

    @Override
    public int getMinimumSymbols() {
        return this.minimumSymbols;
    }

    public void setMinimumSymbols(int minimumSymbols) {
        this.minimumSymbols = minimumSymbols;
    }

    @Override
    public int getMinimumDigits() {
        return this.minimumDigits;
    }

    public void setMinimumDigits(int minimumDigits) {
        this.minimumDigits = minimumDigits;
    }

    @Override
    public int getRequiredMatches() {
        return this.requiresMatches;
    }

    public int getRequiresMatches() {
        return this.requiresMatches;
    }

    @Override
    public boolean isContainUsername() {
        return this.containUsername;
    }

    public void setContainUsername(boolean containUsername) {
        this.containUsername = containUsername;
    }

    public void setRequiresMatches(int requiresMatches) {
        this.requiresMatches = requiresMatches;
    }

    public String toString() {
        return Util.fromObject(this);
    }
}

