/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util.passwords;

import com.identity4j.util.passwords.PasswordAnalysis;
import com.identity4j.util.passwords.PasswordCharacteristics;
import com.identity4j.util.passwords.PasswordDictionaryService;
import com.identity4j.util.passwords.PasswordPolicyException;
import com.nulabinc.zxcvbn.Strength;
import com.nulabinc.zxcvbn.Zxcvbn;
import java.util.ArrayList;
import java.util.Locale;

public class PasswordAnalyser {
    private PasswordDictionaryService dictionaryService;

    public PasswordDictionaryService getDictionaryService() {
        return this.dictionaryService;
    }

    public void setDictionaryService(PasswordDictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public PasswordAnalysis analyse(Locale locale, String username, char[] password, PasswordCharacteristics characteristics) throws PasswordPolicyException {
        int lowerCase = 0;
        int upperCase = 0;
        int digit = 0;
        int other = 0;
        int unmatched = 0;
        char[] symbols = characteristics.getSymbols();
        String others = new String(symbols);
        for (char ch : password) {
            if (Character.isDigit(ch)) {
                ++digit;
                continue;
            }
            if (Character.isLowerCase(ch)) {
                ++lowerCase;
                continue;
            }
            if (Character.isUpperCase(ch)) {
                ++upperCase;
                continue;
            }
            if (others.indexOf(ch) != -1) {
                ++other;
                continue;
            }
            ++unmatched;
        }
        float idealStrength = characteristics.getMinimumSize();
        idealStrength += (float)Math.max(0, characteristics.getMinimumDigits());
        idealStrength += (float)Math.max(0, characteristics.getMinimumLowerCase());
        idealStrength += (float)Math.max(0, characteristics.getMinimumUpperCase());
        idealStrength += (float)Math.max(0, characteristics.getMinimumSymbols());
        idealStrength *= Math.max(0.0f, characteristics.getVeryStrongFactor());
        idealStrength = Math.max(1.0f, idealStrength);
        float actualStrength = digit + lowerCase + upperCase + other;
        actualStrength += (float)unmatched;
        actualStrength = Math.min(idealStrength, actualStrength);
        PasswordAnalysis analysis = new PasswordAnalysis(actualStrength / idealStrength);
        if (characteristics.getMinimumSize() != -1 && password.length < characteristics.getMinimumSize()) {
            throw new PasswordPolicyException(PasswordPolicyException.Type.tooShort, analysis);
        }
        if (characteristics.getMaximumSize() != -1 && password.length > characteristics.getMaximumSize()) {
            throw new PasswordPolicyException(PasswordPolicyException.Type.tooLong, analysis);
        }
        if (username != null && !characteristics.isContainUsername() && new String(password).toLowerCase().contains(username.toLowerCase())) {
            throw new PasswordPolicyException(PasswordPolicyException.Type.containsUsername, analysis);
        }
        if (!characteristics.isDictionaryWordsAllowed()) {
            StringBuilder bui = new StringBuilder();
            ArrayList<String> words = new ArrayList<String>();
            for (char ch : password) {
                if (Character.isLetter(ch)) {
                    bui.append(ch);
                    continue;
                }
                if (bui.length() <= 0) continue;
                words.add(bui.toString());
                bui.setLength(0);
            }
            Object object = words.iterator();
            while (object.hasNext()) {
                String word = (String)object.next();
                if (word.length() <= 3 || this.dictionaryService == null || !this.dictionaryService.containsWord(locale, word)) continue;
                throw new PasswordPolicyException(PasswordPolicyException.Type.containsDictionaryWords, analysis);
            }
        }
        if (characteristics.getRequiredMatches() == 4) {
            this.check(PasswordPolicyException.Type.notEnoughDigits, digit, characteristics.getMinimumDigits(), analysis);
            this.check(PasswordPolicyException.Type.notEnoughLowerCase, lowerCase, characteristics.getMinimumLowerCase(), analysis);
            this.check(PasswordPolicyException.Type.notEnoughUpperCase, upperCase, characteristics.getMinimumUpperCase(), analysis);
            this.check(PasswordPolicyException.Type.notEnoughSymbols, other, characteristics.getMinimumSymbols(), analysis);
        } else {
            int matches = 0;
            if (this.matches(PasswordPolicyException.Type.notEnoughDigits, digit, characteristics.getMinimumDigits(), analysis)) {
                ++matches;
            }
            if (this.matches(PasswordPolicyException.Type.notEnoughLowerCase, lowerCase, characteristics.getMinimumLowerCase(), analysis)) {
                ++matches;
            }
            if (this.matches(PasswordPolicyException.Type.notEnoughUpperCase, upperCase, characteristics.getMinimumUpperCase(), analysis)) {
                ++matches;
            }
            if (this.matches(PasswordPolicyException.Type.notEnoughSymbols, other, characteristics.getMinimumSymbols(), analysis)) {
                ++matches;
            }
            if (matches < characteristics.getRequiredMatches()) {
                throw new PasswordPolicyException(PasswordPolicyException.Type.doesNotMatchComplexity, analysis);
            }
        }
        if (characteristics.isAdditionalAnalysis()) {
            Zxcvbn zxcvbn = new Zxcvbn();
            Strength zstrength = zxcvbn.measure(new String(password));
            analysis.setStrength((float)zstrength.getScore() / 4.0f);
            analysis.setSuggestions(zstrength.getFeedback().getSuggestions().toArray(new String[0]));
            analysis.setWarning(zstrength.getFeedback().getWarning());
        }
        if (analysis.getStrength() < characteristics.getMinStrength()) {
            throw new PasswordPolicyException(PasswordPolicyException.Type.doesNotMatchMinimumStrength, analysis);
        }
        return analysis;
    }

    private void check(PasswordPolicyException.Type type, int val, int req, PasswordAnalysis analysis) throws PasswordPolicyException {
        if (!this.matches(type, val, req, analysis)) {
            throw new PasswordPolicyException(type, analysis);
        }
    }

    private boolean matches(PasswordPolicyException.Type type, int val, int req, PasswordAnalysis analysis) throws PasswordPolicyException {
        return req == -1 || val >= req;
    }
}

