/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util.passwords;

import com.identity4j.util.passwords.PasswordAnalyser;
import com.identity4j.util.passwords.PasswordAnalysis;
import com.identity4j.util.passwords.PasswordCharacteristics;
import com.identity4j.util.passwords.PasswordPolicyException;
import java.util.Arrays;
import java.util.Locale;

public class PasswordGenerator {
    private static final Character[] VOWELS = new Character[]{Character.valueOf('a'), Character.valueOf('e'), Character.valueOf('i'), Character.valueOf('o'), Character.valueOf('u')};
    private PasswordCharacteristics characteristics;
    private int maximumSymbols = -1;
    private int maximumLowerCase = -1;
    private int maximumUpperCase = -1;
    private int maximumDigits = -1;
    private String order = null;
    private PasswordAnalyser analyser;

    public PasswordGenerator() {
    }

    public PasswordGenerator(PasswordAnalyser analyser) {
        this.analyser = analyser;
    }

    public PasswordAnalyser getPasswordAnalyserService() {
        return this.analyser;
    }

    public void setPasswordAnalyserService(PasswordAnalyser analyser) {
        this.analyser = analyser;
    }

    public PasswordGenerator(PasswordAnalyser analyser, PasswordCharacteristics characteristics) {
        this.setPasswordCharacteristics(characteristics);
        this.analyser = analyser;
    }

    public void setOrder(char[] order) {
        this.order = order == null || order.length == 0 ? null : new String(order);
    }

    public int getMaximumSymbols() {
        return this.maximumSymbols;
    }

    public int getMaximumLowerCase() {
        return this.maximumLowerCase;
    }

    public int getMaximumUpperCase() {
        return this.maximumUpperCase;
    }

    public int getMaximumDigits() {
        return this.maximumDigits;
    }

    public char[] generate(Locale locale, String username) {
        if (this.characteristics == null) {
            throw new IllegalStateException("Characteristics not set");
        }
        if (this.analyser == null) {
            throw new IllegalStateException("Analyser not set");
        }
        if (this.characteristics.getMaximumSize() > 0) {
            if (this.characteristics.getMaximumSize() < this.characteristics.getMinimumSize()) {
                throw new IllegalArgumentException("Maximum size must be < 1 or >= minimum size");
            }
            if (Math.max(0, this.characteristics.getMinimumLowerCase()) + Math.max(0, this.characteristics.getMinimumUpperCase()) + Math.max(0, this.characteristics.getMinimumSymbols()) + Math.max(0, this.characteristics.getMinimumDigits()) > this.characteristics.getMaximumSize()) {
                throw new IllegalArgumentException("Total of mimimum sizes of characters type must not exceed maximum size of " + this.characteristics.getMaximumSize());
            }
            if (Math.max(0, this.maximumLowerCase) + Math.max(0, this.maximumUpperCase) + Math.max(0, this.maximumSymbols) + Math.max(0, this.maximumDigits) > this.characteristics.getMaximumSize()) {
                throw new IllegalArgumentException("Total of maximum sizes of characters type must not exceed maximum size of " + this.characteristics.getMaximumSize());
            }
        }
        int diff = this.characteristics.getMaximumSize() - this.characteristics.getMinimumSize();
        int off = (int)Math.round((double)diff * Math.random());
        int targetLength = Math.min(this.characteristics.getMaximumSize() < 1 ? Integer.MAX_VALUE : this.characteristics.getMaximumSize(), this.characteristics.getMinimumSize() + off);
        StringBuilder pw = new StringBuilder();
        char prevChar = '\u0000';
        block12: for (char o : this.isAllClasses() ? (Math.random() > 0.5 ? "DULS".toCharArray() : "ULDS".toCharArray()) : this.order.toCharArray()) {
            switch (o) {
                case 'u': {
                    prevChar = this.doUpperCase(pw);
                    continue block12;
                }
                case 'l': {
                    prevChar = this.doLowerCase(pw, prevChar);
                    continue block12;
                }
                case 'd': {
                    prevChar = this.doDigit(pw);
                    continue block12;
                }
                case 's': {
                    prevChar = this.doSymbol(pw, prevChar);
                    continue block12;
                }
                case 'U': {
                    prevChar = this.doAddUpper(targetLength, pw, prevChar);
                    continue block12;
                }
                case 'L': {
                    prevChar = this.doAddLower(targetLength, pw, prevChar);
                    continue block12;
                }
                case 'D': {
                    prevChar = this.doAllDigits(pw, targetLength, prevChar);
                    continue block12;
                }
                case 'S': {
                    prevChar = this.doSymbols(targetLength, pw, prevChar);
                    continue block12;
                }
                default: {
                    throw new IllegalArgumentException("Incorrect password generation format. Contact the administrator.");
                }
            }
        }
        int loops = 0;
        while (++loops > 0) {
            if (loops > 10000) {
                throw new Error("Password generator is looping suggesting there is a bug. As a work around, you might try adjusting your password policy. " + this.toString());
            }
            try {
                this.analyser.analyse(locale, username, pw.toString().toCharArray(), this.characteristics);
                if (pw.length() < targetLength) {
                    throw new PasswordPolicyException(PasswordPolicyException.Type.tooShort, new PasswordAnalysis());
                }
                break;
            }
            catch (PasswordPolicyException pe) {
                if (pe.getType().equals((Object)PasswordPolicyException.Type.tooLong)) {
                    pw.deleteCharAt((int)Math.random() * pw.length());
                    continue;
                }
                if (pe.getType().equals((Object)PasswordPolicyException.Type.tooShort)) {
                    prevChar = this.appendChar(pw, prevChar);
                    continue;
                }
                if (pw.length() > this.characteristics.getMaximumSize()) {
                    pw.deleteCharAt((int)Math.random() * pw.length());
                }
                prevChar = this.appendChar(pw, prevChar);
            }
        }
        return pw.toString().toCharArray();
    }

    private boolean isClassInUse(char c) {
        return this.isAllClasses() || this.order.indexOf(Character.toUpperCase(c)) != -1 || this.order.indexOf(Character.toLowerCase(c)) != -1;
    }

    private boolean isAllClasses() {
        return this.order == null || this.order.length() == 0;
    }

    protected char doSymbols(int targetLength, StringBuilder pw, char prevChar) {
        int c = this.characteristics.getMinimumSymbols();
        if (c != -1 && this.characteristics.getSymbols() != null && this.characteristics.getSymbols().length > 0) {
            c = this.calcCharactersToAdd(c, this.maximumSymbols, targetLength);
            for (int i = 0; i < c; ++i) {
                prevChar = this.doSymbol(pw, prevChar);
            }
        }
        return prevChar;
    }

    protected char doAddLower(int targetLength, StringBuilder pw, char prevChar) {
        int c = this.calcCharactersToAdd(this.characteristics.getMinimumLowerCase(), this.maximumLowerCase, targetLength);
        for (int i = 0; i < c; ++i) {
            prevChar = this.doLowerCase(pw, prevChar);
        }
        return prevChar;
    }

    protected char doAddUpper(int targetLength, StringBuilder pw, char prevChar) {
        int c = this.calcCharactersToAdd(this.characteristics.getMinimumUpperCase(), this.maximumUpperCase, targetLength);
        for (int i = 0; i < c; ++i) {
            prevChar = (char)(65.0 + Math.random() * 26.0);
            pw.append(prevChar);
        }
        return prevChar;
    }

    protected int calcCharactersToAdd(int minimum, int maximum, int targetLength) {
        if (maximum == 0) {
            return 0;
        }
        if (maximum == -1) {
            maximum = targetLength;
        }
        int min = minimum == 0 ? (int)Math.round((double)targetLength * 0.1) : minimum;
        int c = min + (int)((double)(maximum - min + 1) * Math.random());
        return c;
    }

    private char doAllDigits(StringBuilder pw, int targetLength, char prevChar) {
        int c = this.calcCharactersToAdd(this.characteristics.getMinimumDigits(), this.maximumDigits, targetLength);
        for (int i = 0; i < c; ++i) {
            prevChar = this.doDigit(pw);
        }
        return prevChar;
    }

    private char doDigit(StringBuilder pw) {
        char generateDigit = this.generateDigit();
        pw.append(generateDigit);
        return generateDigit;
    }

    private char doSymbol(StringBuilder pw, char prevChar) {
        char[] symbols = this.characteristics.getSymbols();
        if (symbols.length > 0) {
            char c = symbols[(int)(Math.random() * (double)symbols.length)];
            pw.append(c);
            return c;
        }
        return prevChar;
    }

    private char appendChar(StringBuilder pw, char prevChar) {
        block5: for (int i = 0; i < 9999; ++i) {
            switch ((int)(Math.random() * 8.0)) {
                case 0: {
                    if (!this.isClassInUse('U')) continue block5;
                    prevChar = this.doUpperCase(pw);
                    return prevChar;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    if (!this.isClassInUse('L')) continue block5;
                    prevChar = this.doLowerCase(pw, prevChar);
                    i = Integer.MAX_VALUE;
                    return prevChar;
                }
                case 6: {
                    if (!this.isClassInUse('D')) continue block5;
                    pw.append(this.generateDigit());
                    return prevChar;
                }
                default: {
                    if (!this.isClassInUse('S')) continue block5;
                    this.doSymbol(pw, prevChar);
                    return prevChar;
                }
            }
        }
        return prevChar;
    }

    private char doUpperCase(StringBuilder pw) {
        char prevChar = (char)(65.0 + Math.random() * 26.0);
        pw.append(prevChar);
        return prevChar;
    }

    private char doLowerCase(StringBuilder pw, char prevChar) {
        prevChar = prevChar != '\u0000' && !this.isVowel(prevChar) ? VOWELS[(int)(Math.random() * (double)VOWELS.length)].charValue() : (char)(97.0 + Math.random() * 26.0);
        pw.append(prevChar);
        return prevChar;
    }

    private char generateDigit() {
        return (char)(48.0 + Math.random() * 10.0);
    }

    private boolean isVowel(char ch) {
        return Arrays.asList(VOWELS).contains(Character.valueOf(ch));
    }

    public void setPasswordCharacteristics(PasswordCharacteristics characteristics) {
        this.characteristics = characteristics;
    }

    public PasswordCharacteristics getPasswordCharacteristics() {
        return this.characteristics;
    }

    public void setMaximumSymbols(int maximumSymbols) {
        this.maximumSymbols = maximumSymbols;
    }

    public void setMaximumLowerCase(int maximumLowerCase) {
        this.maximumLowerCase = maximumLowerCase;
    }

    public void setMaximumUpperCase(int maximumUpperCase) {
        this.maximumUpperCase = maximumUpperCase;
    }

    public void setMaximumDigits(int maximumDigits) {
        this.maximumDigits = maximumDigits;
    }

    public String toString() {
        return "PasswordGeneratorServiceImpl [characteristics=" + this.characteristics + ", maximumSymbols=" + this.maximumSymbols + ", maximumLowerCase=" + this.maximumLowerCase + ", maximumUpperCase=" + this.maximumUpperCase + ", maximumDigits=" + this.maximumDigits + ", order=" + this.order + ", analyser=" + this.analyser + "]";
    }
}

