/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util.unix;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class SHACrypt {
    static char[] itoa64 = "./0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".toCharArray();

    private static String cryptTo64(long v, int n) {
        StringBuilder result = new StringBuilder();
        while (--n >= 0) {
            result.append(itoa64[(int)v & 0x3F]);
            v >>= 6;
        }
        return result.toString();
    }

    private static void memset(byte[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = 0;
        }
    }

    public static String crypt_sha(byte[] pw, String salt) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        return SHACrypt.crypt_sha(pw, salt, 512);
    }

    public static String crypt_sha(byte[] pw, String salt, int size) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String magic = null;
        switch (size) {
            case 256: {
                magic = "$5$";
                break;
            }
            case 512: {
                magic = "$6$";
                break;
            }
            default: {
                throw new IllegalArgumentException("Size must be 256 or 512");
            }
        }
        int blockSize = size == 512 ? 64 : 32;
        StringBuilder outputString = new StringBuilder();
        byte[] altResult = new byte[size == 512 ? 86 : 43];
        byte[] tempResult = new byte[size == 512 ? 86 : 43];
        int saltLength = 0;
        int cnt = 0;
        MessageDigest ctx = MessageDigest.getInstance("SHA-" + size);
        MessageDigest altCtx = MessageDigest.getInstance("SHA-" + size);
        String saltText = salt;
        if (saltText.startsWith(magic)) {
            saltText = saltText.substring(magic.length());
        }
        long rounds = 5000L;
        boolean customRounds = false;
        if (saltText.startsWith("rounds=")) {
            rounds = Long.parseLong(saltText.substring(7, saltText.indexOf(36)));
            if (rounds < 1000L || rounds > 999999999L) {
                throw new IllegalArgumentException("Invalid number of rounds. Must be between 1000 and 999999999");
            }
            saltText = saltText.substring(saltText.indexOf(36) + 1);
            customRounds = true;
        }
        byte[] saltBytes = saltText.getBytes("UTF8");
        String ep = saltText;
        if (ep != null) {
            int endSalt = ep.indexOf(36);
            saltLength = endSalt == -1 ? ep.length() : (endSalt >= 0 && endSalt <= 15 ? endSalt + 1 : 16);
        }
        ctx.reset();
        ctx.update(pw, 0, pw.length);
        System.out.println("ACTUAL SALT: " + new String(saltBytes, 0, saltLength));
        ctx.update(saltBytes, 0, saltLength);
        altCtx.reset();
        altCtx.update(pw, 0, pw.length);
        altCtx.update(saltBytes, 0, saltLength);
        altCtx.update(pw, 0, pw.length);
        altResult = altCtx.digest();
        for (cnt = pw.length; cnt > blockSize; cnt -= blockSize) {
            ctx.update(altResult, 0, blockSize);
        }
        ctx.update(altResult, 0, cnt);
        for (cnt = pw.length; cnt > 0; cnt >>= 1) {
            if ((cnt & 1) != 0) {
                ctx.update(altResult, 0, blockSize);
                continue;
            }
            ctx.update(pw, 0, pw.length);
        }
        altResult = ctx.digest();
        altCtx.reset();
        for (cnt = 0; cnt < pw.length; ++cnt) {
            altCtx.update(pw, 0, pw.length);
        }
        tempResult = altCtx.digest();
        byte[] pBytes = new byte[pw.length];
        for (cnt = pw.length; cnt >= blockSize; cnt -= blockSize) {
            System.arraycopy(tempResult, 0, pBytes, 0, blockSize);
        }
        System.arraycopy(tempResult, 0, pBytes, 0, cnt);
        altCtx.reset();
        for (cnt = 0; cnt < 16 + altResult[0]; ++cnt) {
            altCtx.update(saltBytes, 0, saltLength);
        }
        tempResult = altCtx.digest();
        byte[] sBytes = new byte[saltLength];
        for (cnt = saltLength; cnt >= blockSize; cnt -= blockSize) {
            System.arraycopy(tempResult, 0, sBytes, 0, blockSize);
        }
        System.arraycopy(tempResult, 0, sBytes, 0, cnt);
        cnt = 0;
        while ((long)cnt < rounds) {
            ctx.reset();
            if ((cnt & 1) != 0) {
                ctx.update(pw, 0, pw.length);
            } else {
                ctx.update(altResult, 0, altResult.length);
            }
            if (cnt % 3 != 0) {
                ctx.update(saltBytes, 0, saltLength);
            }
            if (cnt % 7 != 0) {
                ctx.update(pw, 0, pw.length);
            }
            if ((cnt & 1) != 0) {
                ctx.update(altResult, 0, altResult.length);
            } else {
                ctx.update(pw, 0, pw.length);
            }
            altResult = ctx.digest();
            ++cnt;
        }
        outputString.append(magic);
        if (customRounds) {
            outputString.append("rounds=" + rounds + "$");
        }
        outputString.append(saltText.substring(0, saltLength));
        outputString.append("$");
        if (size == 256) {
            outputString.append(SHACrypt.b64From24Bit(altResult[0], altResult[10], altResult[20], 4));
            outputString.append(SHACrypt.b64From24Bit(altResult[21], altResult[1], altResult[11], 4));
            outputString.append(SHACrypt.b64From24Bit(altResult[12], altResult[22], altResult[2], 4));
            outputString.append(SHACrypt.b64From24Bit(altResult[3], altResult[13], altResult[23], 4));
            outputString.append(SHACrypt.b64From24Bit(altResult[24], altResult[4], altResult[14], 4));
            outputString.append(SHACrypt.b64From24Bit(altResult[15], altResult[25], altResult[5], 4));
            outputString.append(SHACrypt.b64From24Bit(altResult[6], altResult[7], altResult[26], 4));
            outputString.append(SHACrypt.b64From24Bit(altResult[27], altResult[28], altResult[17], 4));
            outputString.append(SHACrypt.b64From24Bit(altResult[18], altResult[19], altResult[8], 4));
            outputString.append(SHACrypt.b64From24Bit(altResult[9], altResult[30], altResult[29], 4));
            outputString.append(SHACrypt.b64From24Bit((byte)0, altResult[31], altResult[30], 3));
        } else {
            outputString.append(SHACrypt.b64From24Bit(altResult[0], altResult[21], altResult[42], 4));
            outputString.append(SHACrypt.b64From24Bit(altResult[22], altResult[43], altResult[1], 4));
            outputString.append(SHACrypt.b64From24Bit(altResult[44], altResult[2], altResult[23], 4));
            outputString.append(SHACrypt.b64From24Bit(altResult[3], altResult[24], altResult[45], 4));
            outputString.append(SHACrypt.b64From24Bit(altResult[25], altResult[46], altResult[4], 4));
            outputString.append(SHACrypt.b64From24Bit(altResult[47], altResult[5], altResult[26], 4));
            outputString.append(SHACrypt.b64From24Bit(altResult[6], altResult[27], altResult[48], 4));
            outputString.append(SHACrypt.b64From24Bit(altResult[28], altResult[49], altResult[7], 4));
            outputString.append(SHACrypt.b64From24Bit(altResult[50], altResult[8], altResult[29], 4));
            outputString.append(SHACrypt.b64From24Bit(altResult[9], altResult[30], altResult[51], 4));
            outputString.append(SHACrypt.b64From24Bit(altResult[31], altResult[52], altResult[10], 4));
            outputString.append(SHACrypt.b64From24Bit(altResult[53], altResult[11], altResult[32], 4));
            outputString.append(SHACrypt.b64From24Bit(altResult[12], altResult[33], altResult[54], 4));
            outputString.append(SHACrypt.b64From24Bit(altResult[34], altResult[55], altResult[13], 4));
            outputString.append(SHACrypt.b64From24Bit(altResult[56], altResult[14], altResult[35], 4));
            outputString.append(SHACrypt.b64From24Bit(altResult[15], altResult[36], altResult[57], 4));
            outputString.append(SHACrypt.b64From24Bit(altResult[37], altResult[58], altResult[16], 4));
            outputString.append(SHACrypt.b64From24Bit(altResult[59], altResult[17], altResult[38], 4));
            outputString.append(SHACrypt.b64From24Bit(altResult[18], altResult[39], altResult[60], 4));
            outputString.append(SHACrypt.b64From24Bit(altResult[40], altResult[61], altResult[19], 4));
            outputString.append(SHACrypt.b64From24Bit(altResult[62], altResult[20], altResult[41], 4));
            outputString.append(SHACrypt.b64From24Bit((byte)0, (byte)0, altResult[63], 2));
        }
        SHACrypt.memset(altResult);
        return outputString.toString();
    }

    private static String b64From24Bit(byte b2, byte b1, byte b0, int n) {
        long l = SHACrypt.byteToUnsigned(b2) << 16 | SHACrypt.byteToUnsigned(b1) << 8 | SHACrypt.byteToUnsigned(b0);
        return SHACrypt.cryptTo64(l, 4);
    }

    private static int byteToUnsigned(byte aByte) {
        return aByte & 0xFF;
    }

    public static boolean verifySHAPassword(String plaintext, String ciphertext) throws NoSuchAlgorithmException {
        if (ciphertext.charAt(0) != '$' || ciphertext.charAt(1) != '5' && ciphertext.charAt(1) != '6' || ciphertext.charAt(2) != '$' || ciphertext.length() < 5) {
            return false;
        }
        int size = ciphertext.charAt(1) == '5' ? 256 : 512;
        StringBuilder salt = new StringBuilder(16);
        int idx = ciphertext.indexOf(36, 3);
        for (int i = 3; i < idx; ++i) {
            salt.append(ciphertext.charAt(i));
        }
        try {
            String our_ciphertext = SHACrypt.crypt_sha(plaintext.getBytes("UTF8"), salt.toString(), size);
            return our_ciphertext.equals(ciphertext);
        }
        catch (UnsupportedEncodingException uee) {
            return false;
        }
    }

    public static String shaCrypt(String password, String charset, int size) throws NoSuchAlgorithmException {
        char[] saltChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789./".toCharArray();
        int numSaltChars = saltChars.length;
        StringBuilder salt = new StringBuilder(16);
        SecureRandom rand = new SecureRandom();
        for (int i = 0; i < 16; ++i) {
            salt.append(saltChars[rand.nextInt(Integer.MAX_VALUE) % numSaltChars]);
        }
        try {
            if (password == null) {
                password = "";
            }
            String encrypted = SHACrypt.crypt_sha(password.getBytes(charset), salt.toString(), size);
            return encrypted;
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
    }
}

