/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util.validator;

import com.identity4j.util.MultiMap;
import com.identity4j.util.StringUtil;
import com.identity4j.util.validator.ValidationContext;
import com.identity4j.util.validator.ValidationError;
import com.identity4j.util.validator.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public abstract class AbstractSingleValueValidator
implements Validator {
    public static final String TRIM = "TRIM";
    public static final String REQUIRED = "REQUIRED";
    private final boolean trim;
    private boolean required;

    public AbstractSingleValueValidator(MultiMap parameters) {
        this.trim = parameters.getBooleanOrDefault(TRIM, true);
        this.required = parameters.getBooleanOrDefault(REQUIRED, false);
    }

    @Override
    public final Collection<ValidationError> validate(ValidationContext context, String ... values) {
        if (values == null) {
            throw new IllegalArgumentException("Null values provided");
        }
        ArrayList<ValidationError> results = new ArrayList<ValidationError>();
        if (values.length == 0) {
            results.addAll(this.fixAndValidate(""));
        } else {
            for (String value : values) {
                results.addAll(this.fixAndValidate(value));
            }
        }
        return results;
    }

    @Override
    public boolean isValueRequired() {
        return this.required;
    }

    private Collection<ValidationError> fixAndValidate(String value) {
        String trimmedValue;
        String nonNull = StringUtil.nonNull(value);
        String string = trimmedValue = this.trim ? nonNull.trim() : nonNull;
        if (trimmedValue.equals("") && !this.isValueRequired()) {
            return Collections.emptyList();
        }
        return this.validate((ValidationContext)null, trimmedValue);
    }

    abstract Collection<ValidationError> validate(ValidationContext var1, String var2);

    public String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append("[trim='").append(this.trim).append("']");
        return builder.toString();
    }
}

