/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util.validator;

import com.identity4j.util.MultiMap;
import com.identity4j.util.validator.AbstractSingleValueValidator;
import com.identity4j.util.validator.ValidationContext;
import com.identity4j.util.validator.ValidationError;
import java.util.Collection;
import java.util.Collections;

public class BooleanValidator
extends AbstractSingleValueValidator {
    public static final String TRUE_VALUE = "TRUE_VALUE";
    public static final String FALSE_VALUE = "FALSE_VALUE";
    private final String trueValue;
    private final String falseValue;

    public BooleanValidator(MultiMap parameters) {
        super(parameters);
        this.trueValue = parameters.getStringOrDefault(TRUE_VALUE, "true");
        this.falseValue = parameters.getStringOrDefault(FALSE_VALUE, "false");
    }

    @Override
    final Collection<ValidationError> validate(ValidationContext context, String value) {
        if (!this.trueValue.equals(value) && !this.falseValue.equals(value)) {
            return Collections.singleton(new ValidationError("boolean.value.invalid", context, value, this.trueValue, this.falseValue));
        }
        return Collections.emptyList();
    }

    @Override
    public final String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append("[trueValue='").append(this.trueValue);
        builder.append("', falseValue='").append(this.falseValue).append("']");
        return builder.toString();
    }

    @Override
    public boolean isValueRequired() {
        return false;
    }
}

