/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util.validator;

import com.identity4j.util.MultiMap;
import com.identity4j.util.validator.AbstractSingleValueValidator;
import com.identity4j.util.validator.ValidationContext;
import com.identity4j.util.validator.ValidationError;
import java.util.Collection;
import java.util.Collections;

public class IntegerValidator
extends AbstractSingleValueValidator {
    public static final String MINIMUM_VALUE = "MINIMUM_VALUE";
    public static final String MAXIMUM_VALUE = "MAXIMUM_VALUE";
    private final int minimumValue;
    private final int maximumValue;

    public IntegerValidator(MultiMap parameters) {
        super(parameters);
        this.minimumValue = parameters.getIntegerOrDefault(MINIMUM_VALUE, 0);
        this.maximumValue = parameters.getIntegerOrDefault(MAXIMUM_VALUE, Integer.MAX_VALUE);
    }

    @Override
    final Collection<ValidationError> validate(ValidationContext context, String value) {
        try {
            Integer valueOf = Integer.valueOf(value);
            if (valueOf < this.minimumValue) {
                return Collections.singleton(new ValidationError("integer.value.too.small", context, valueOf, this.minimumValue));
            }
            if (valueOf > this.maximumValue) {
                return Collections.singleton(new ValidationError("integer.value.too.large", context, valueOf, this.maximumValue));
            }
            return Collections.emptyList();
        }
        catch (NumberFormatException nfe) {
            return Collections.singleton(new ValidationError("integer.value.invalid", context, value));
        }
    }

    @Override
    public final String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append("[minimumValue='").append(this.minimumValue);
        builder.append("', maximumValue='").append(this.maximumValue).append("']");
        return builder.toString();
    }

    @Override
    public boolean isValueRequired() {
        return true;
    }
}

