/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util.validator;

import com.identity4j.util.MultiMap;
import com.identity4j.util.StringUtil;
import com.identity4j.util.validator.AbstractSingleValueValidator;
import com.identity4j.util.validator.ValidationContext;
import com.identity4j.util.validator.ValidationError;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;

public class IpAddressValidator
extends AbstractSingleValueValidator {
    private static final char PORT_SEPARATOR = ':';
    public static final String INCLUDES_PORT = "INCLUDES_PORT";
    private final boolean includesPort;

    public IpAddressValidator(MultiMap parameters) {
        super(parameters);
        this.includesPort = parameters.getBooleanOrDefault(INCLUDES_PORT, true);
    }

    @Override
    final Collection<ValidationError> validate(ValidationContext context, String value) {
        int indexOf;
        String ipAddress = value;
        if (this.includesPort) {
            int indexOf2 = value.lastIndexOf(58);
            ipAddress = indexOf2 == -1 ? value : value.substring(0, indexOf2);
        }
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (StringUtil.isNullOrEmpty(ipAddress) || !this.isValidHostOrIpAddress(ipAddress)) {
            errors.add(new ValidationError("ipAddress.value.invalid", context, ipAddress));
        }
        if (this.includesPort && (indexOf = value.lastIndexOf(58)) != -1) {
            String potentialPort = value.substring(indexOf + 1, value.length());
            try {
                Integer port = Integer.valueOf(potentialPort);
                if (port < 0 || port > 65535) {
                    errors.add(new ValidationError("ipAddress.port.value.invalid", context, ipAddress));
                }
            }
            catch (NumberFormatException nfe) {
                errors.add(new ValidationError("ipAddress.port.value.invalid", context, ipAddress));
            }
        }
        return errors;
    }

    private boolean isValidHostOrIpAddress(String value) {
        return value.length() > 0 && value.length() < 256 && !value.startsWith(" ") && !value.endsWith(" ");
    }

    public static final boolean isHostName(String ipAddressOrHostName) {
        String[] tokens = ipAddressOrHostName.split("\\.");
        if (tokens.length > 1) {
            return !IpAddressValidator.containsFourNumbericParts(ipAddressOrHostName);
        }
        return false;
    }

    private static boolean containsFourNumbericParts(String ipAddress) {
        int regionCount = 0;
        StringTokenizer tokenizer = new StringTokenizer(ipAddress, ".");
        while (tokenizer.hasMoreTokens()) {
            try {
                String token = tokenizer.nextToken();
                Integer.parseInt(token);
                ++regionCount;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        return 4 == regionCount;
    }

    @Override
    public final String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append("[includesPort='").append(this.includesPort).append("']");
        return builder.toString();
    }
}

