/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util.validator;

import com.identity4j.util.MultiMap;
import com.identity4j.util.StringUtil;
import com.identity4j.util.validator.ValidationContext;
import com.identity4j.util.validator.ValidationError;
import com.identity4j.util.validator.Validator;
import java.util.ArrayList;
import java.util.Collection;

public class ListValidator
implements Validator {
    public static final String LIST_VALUES = "LIST_VALUES";
    public static final String MINIMUM_SELECTION = "MINIMUM_SELECTION";
    public static final String MAXIMUM_SELECTION = "MAXIMUM_SELECTION";
    public static final String TRIM = "TRIM";
    private final Collection<String> listContents;
    private final int minimumSelection;
    private final int maximumSelection;
    private final boolean trim;

    public ListValidator(MultiMap parameters) {
        this.listContents = StringUtil.toDefaultList(parameters.getStringOrDefault(LIST_VALUES, ""));
        this.minimumSelection = parameters.getIntegerOrDefault(MINIMUM_SELECTION, 0);
        this.maximumSelection = parameters.getIntegerOrDefault(MAXIMUM_SELECTION, 1);
        this.trim = parameters.getBooleanOrDefault(TRIM, true);
    }

    @Override
    public final Collection<ValidationError> validate(ValidationContext context, String ... values) {
        if (values == null) {
            throw new IllegalArgumentException("Null values provided");
        }
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (values.length < this.minimumSelection) {
            errors.add(new ValidationError("list.minimum.selection", context, this.minimumSelection));
        } else if (values.length > this.maximumSelection) {
            errors.add(new ValidationError("list.maximum.selection", context, this.maximumSelection));
        }
        if (!this.listContents.isEmpty()) {
            for (String value : values) {
                String trimmedValue;
                String nonNull = StringUtil.nonNull(value);
                String string = trimmedValue = this.trim ? nonNull.trim() : nonNull;
                if (this.listContents.contains(trimmedValue)) continue;
                errors.add(new ValidationError("list.invalid.selection", context, trimmedValue));
            }
        }
        return errors;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append("[listContents='").append(this.listContents);
        builder.append("', minimumSelection='").append(this.minimumSelection);
        builder.append("', maximumSelection='").append(this.maximumSelection).append("']");
        return builder.toString();
    }

    @Override
    public boolean isValueRequired() {
        return this.minimumSelection > 0;
    }
}

