/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util.validator;

import com.identity4j.util.MultiMap;
import com.identity4j.util.validator.AbstractSingleValueValidator;
import com.identity4j.util.validator.ValidationContext;
import com.identity4j.util.validator.ValidationError;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;

public class RegexValidator
extends AbstractSingleValueValidator {
    public static final String REGEX = "REGEX";
    public static final String REGEX_FLAGS = "REGEX_FLAGS";
    private final String regex;
    private Pattern pattern;

    public RegexValidator(MultiMap parameters, String regex, int flags) {
        super(parameters);
        this.regex = regex;
        this.pattern = Pattern.compile(regex, flags);
    }

    public RegexValidator(MultiMap parameters) {
        super(parameters);
        this.regex = parameters.getStringOrDefault(REGEX, ".*");
        this.pattern = Pattern.compile(this.regex, parameters.getIntegerOrDefault(REGEX_FLAGS, 0));
    }

    @Override
    final Collection<ValidationError> validate(ValidationContext context, String value) {
        if (this.pattern.matcher(value).matches()) {
            return Collections.emptyList();
        }
        return Collections.singleton(this.createError(context, value));
    }

    protected ValidationError createError(ValidationContext context, String value) {
        return new ValidationError("regex.pattern.does.not.match", context, value, this.regex);
    }

    @Override
    public final String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append("[regex='").append(this.regex).append("']");
        return builder.toString();
    }
}

