/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util.validator;

import com.identity4j.util.MultiMap;
import com.identity4j.util.validator.AbstractSingleValueValidator;
import com.identity4j.util.validator.ValidationContext;
import com.identity4j.util.validator.ValidationError;
import java.util.Collection;
import java.util.Collections;

public class StringValidator
extends AbstractSingleValueValidator {
    public static final String MINIMUM_LENGTH = "MINIMUM_LENGTH";
    public static final String MAXIMUM_LENGTH = "MAXIMUM_LENGTH";
    private final int minimumLength;
    private final int maximumLength;

    public StringValidator(MultiMap parameters) {
        super(parameters);
        this.minimumLength = parameters.getIntegerOrDefault(MINIMUM_LENGTH, 0);
        this.maximumLength = parameters.getIntegerOrDefault(MAXIMUM_LENGTH, 65536);
    }

    @Override
    final Collection<ValidationError> validate(ValidationContext context, String value) {
        if (value.length() < this.minimumLength) {
            return Collections.singleton(new ValidationError("string.length.too.small", context, value, this.minimumLength));
        }
        if (value.length() > this.maximumLength) {
            return Collections.singleton(new ValidationError("string.length.too.large", context, value, this.maximumLength));
        }
        return Collections.emptyList();
    }

    @Override
    public final String toString() {
        StringBuilder builder = new StringBuilder(super.toString());
        builder.append("[minimumLength='").append(this.minimumLength);
        builder.append("', maximumLength='").append(this.maximumLength).append("']");
        return builder.toString();
    }

    @Override
    public boolean isValueRequired() {
        return super.isValueRequired() || this.minimumLength > 0;
    }
}

