/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util.validator;

import com.identity4j.util.i18n.Messages;
import com.identity4j.util.validator.ValidationContext;
import com.identity4j.util.validator.ValidationError;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ValidationException
extends RuntimeException {
    private static final long serialVersionUID = -7157434556969163365L;
    private final ValidationError validationError;
    private final Map<String, Collection<ValidationError>> validatorErrors = new HashMap<String, Collection<ValidationError>>();

    public ValidationException(ValidationError validationError) {
        super(validationError.getMessage());
        this.validationError = validationError;
    }

    public ValidationException(ValidationContext context, String bundle, String message, Object ... args) {
        this(new ValidationError(bundle, context, message, args));
    }

    public ValidationException(ValidationContext context, String bundle, String message, Throwable cause, Object ... args) {
        super(message, cause);
        this.validationError = new ValidationError(bundle, context, message, args);
    }

    public ValidationException(ValidationContext context, Map<String, Collection<ValidationError>> validatorErrors, Object ... args) {
        this(context, ValidationError.RESOURCE_BUNDLE_VALIDATOR, "muliple.validation.failures", args);
        this.validatorErrors.putAll(validatorErrors);
    }

    public String getLocalizedMessage(ClassLoader classLoader) {
        return this.getLocalizedMessage(classLoader, Locale.getDefault());
    }

    public String getLocalizedMessage(ClassLoader classLoader, Locale locale) {
        return Messages.getString(classLoader, locale, this.validationError.getBundle(), this.validationError.getMessage(), this.validationError.getArgs());
    }

    @Override
    public String getMessage() {
        return super.getMessage() + "." + this.validatorErrors.toString();
    }

    public final ValidationError getValidationError() {
        return this.validationError;
    }

    public Map<String, Collection<ValidationError>> getValidatorErrors() {
        return this.validatorErrors;
    }
}

