/*
 * Decompiled with CFR 0.152.
 */
package com.identity4j.util.xml;

import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class XMLDataExtractor {
    private final XMLInputFactory inputFactory = XMLInputFactory.newInstance();

    private XMLDataExtractor() {
    }

    public static XMLDataExtractor getInstance() {
        return LazyHolder.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Node> extract(String xml, Set<String> nodes) throws XMLStreamException {
        XMLEventReader eventReader = null;
        StringReader xmlStringReader = null;
        HashMap<String, Node> nodeValues = new HashMap<String, Node>();
        try {
            xmlStringReader = new StringReader(xml);
            eventReader = this.inputFactory.createXMLEventReader(xmlStringReader);
            XMLEvent event = null;
            Node node = null;
            boolean isExpectingNodeValue = false;
            while (eventReader.hasNext()) {
                event = eventReader.nextEvent();
                if (event.isStartElement() && isExpectingNodeValue) {
                    node = null;
                }
                if (event.isStartElement() && nodes.contains(event.asStartElement().getName().getLocalPart())) {
                    StartElement startElement = event.asStartElement();
                    node = new Node();
                    node.setNodeName(event.asStartElement().getName().getLocalPart());
                    Iterator<Attribute> attributes = startElement.getAttributes();
                    while (attributes.hasNext()) {
                        Attribute attribute = attributes.next();
                        node.getAttributes().put(attribute.getName().toString(), attribute.getValue());
                    }
                    nodeValues.put(event.asStartElement().getName().getLocalPart(), node);
                    isExpectingNodeValue = true;
                }
                if (!event.isCharacters() || node == null) continue;
                node.setNodeValue(event.asCharacters().getData());
                node = null;
                isExpectingNodeValue = false;
            }
        }
        finally {
            if (xmlStringReader != null) {
                xmlStringReader.close();
            }
            if (eventReader != null) {
                eventReader.close();
            }
        }
        return nodeValues;
    }

    public static class Node {
        private Map<String, String> attributes = new HashMap<String, String>();
        private String nodeName;
        private String nodeValue;

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, String> attributes) {
            this.attributes = attributes;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        public String getNodeValue() {
            return this.nodeValue;
        }

        public void setNodeValue(String nodeValue) {
            this.nodeValue = nodeValue;
        }

        public String toString() {
            return "Node [attributes=" + this.attributes + ", nodeName=" + this.nodeName + ", nodeValue=" + this.nodeValue + "]";
        }
    }

    private static class LazyHolder {
        private static final XMLDataExtractor INSTANCE = new XMLDataExtractor();

        private LazyHolder() {
        }
    }
}

