/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.config;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.util.Providers;
import com.nesscomputing.config.Config;

public class ConfigModule
extends AbstractModule {
    private final Provider<Config> configProvider;

    public static ConfigModule forTesting(String ... keyValuePairs) {
        return new ConfigModule(Config.getFixedConfig(keyValuePairs));
    }

    public static ConfigModule forTesting() {
        return new ConfigModule(Config.getEmptyConfig());
    }

    public ConfigModule() {
        this.configProvider = new Provider<Config>(){

            public Config get() {
                return Config.getConfig();
            }
        };
    }

    public ConfigModule(Config config) {
        this.configProvider = Providers.of((Object)config);
    }

    @Deprecated
    public ConfigModule(String ... keyValuePairs) {
        this(Config.getFixedConfig(keyValuePairs));
    }

    public void configure() {
        this.bind(Config.class).toProvider(this.configProvider).in(Scopes.SINGLETON);
    }
}

