/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.config.util;

import com.nesscomputing.config.Config;
import com.nesscomputing.config.util.AbstractConfigStrategy;
import com.nesscomputing.logging.Log;
import java.net.URI;
import java.net.URL;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;

public class ClasspathConfigStrategy
extends AbstractConfigStrategy {
    private static Log LOG = Log.findLog();

    public ClasspathConfigStrategy() {
        this(URI.create("classpath:/config"));
    }

    public ClasspathConfigStrategy(URI configLocation) {
        super(configLocation);
        LOG.trace("Searching for configuration at '%s' on the classpath.", new Object[]{this.getLocation().getPath()});
    }

    @Override
    public AbstractConfiguration load(String configName, String configPath) throws ConfigurationException {
        String[] propertyFileNames;
        String classpathPrefix = this.getLocation().getPath();
        for (String propertyFileName : propertyFileNames = new String[]{classpathPrefix + "/" + configPath + "/config.properties", classpathPrefix + "/" + configName + ".properties"}) {
            LOG.trace("Trying to load '%s'...", new Object[]{propertyFileName});
            URL configUrl = Config.class.getResource(propertyFileName);
            if (configUrl != null) {
                LOG.trace("... succeeded");
                return new PropertiesConfiguration(configUrl);
            }
            LOG.trace("... failed");
        }
        return null;
    }
}

