/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.config.util;

import com.nesscomputing.config.util.AbstractConfigStrategy;
import com.nesscomputing.config.util.ConfigAuthCredentials;
import com.nesscomputing.logging.Log;
import com.nesscomputing.tinyhttp.HttpContentConverter;
import com.nesscomputing.tinyhttp.HttpFetcher;
import com.nesscomputing.tinyhttp.ssl.SSLConfig;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import javax.annotation.Nonnull;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.skife.config.CommonsConfigSource;
import org.skife.config.ConfigSource;
import org.skife.config.ConfigurationObjectFactory;

public class HttpConfigStrategy
extends AbstractConfigStrategy {
    private static Log LOG = Log.findLog();
    private static final HttpContentConverter<AbstractConfiguration> CONFIG_CONVERTER = new AbstractConfigurationConverter();
    private final URI webLocation;

    public HttpConfigStrategy(@Nonnull URI webLocation) {
        super(webLocation);
        String web = webLocation.toString();
        this.webLocation = web.endsWith("/") ? webLocation : URI.create(web + "/");
        LOG.trace("Searching for configuration at '%s'.", new Object[]{webLocation});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractConfiguration load(String configName, String configPath) throws ConfigurationException {
        ConfigurationObjectFactory objectFactory = new ConfigurationObjectFactory((ConfigSource)new CommonsConfigSource(new SystemConfiguration().subset("config")));
        SSLConfig sslConfig = (SSLConfig)objectFactory.build(SSLConfig.class);
        HttpFetcher httpFetcher = new HttpFetcher(sslConfig);
        ConfigAuthCredentials configAuthCredentials = (ConfigAuthCredentials)objectFactory.build(ConfigAuthCredentials.class);
        try {
            URI[] propertyUris;
            for (URI propertyUri : propertyUris = new URI[]{this.webLocation.resolve(configPath + "/config.properties"), this.webLocation.resolve(configName + ".properties")}) {
                block8: {
                    LOG.trace("Trying to load '%s'...", new Object[]{propertyUri});
                    AbstractConfiguration config = (AbstractConfiguration)httpFetcher.get(propertyUri, configAuthCredentials.getLogin(), configAuthCredentials.getPassword(), CONFIG_CONVERTER);
                    if (config == null) break block8;
                    LOG.trace("... succeeded");
                    AbstractConfiguration abstractConfiguration = config;
                    return abstractConfiguration;
                }
                try {
                    LOG.trace("... not found");
                }
                catch (IOException ioe) {
                    LOG.trace((Throwable)ioe, "... failed");
                }
            }
            AbstractConfiguration abstractConfiguration = null;
            return abstractConfiguration;
        }
        finally {
            httpFetcher.close();
        }
    }

    private static final class AbstractConfigurationConverter
    implements HttpContentConverter<AbstractConfiguration> {
        private AbstractConfigurationConverter() {
        }

        public AbstractConfiguration convert(HttpRequest request, HttpResponse response, InputStream inputStream) throws IOException {
            switch (response.getStatusLine().getStatusCode()) {
                case 404: {
                    return null;
                }
                case 401: {
                    throw new IllegalStateException(String.format("Could not load configuration from '%s', not authorized!", request.getRequestLine().getUri()));
                }
                case 200: {
                    try {
                        PropertiesConfiguration config = new PropertiesConfiguration();
                        config.load(inputStream);
                        return config;
                    }
                    catch (ConfigurationException ce) {
                        throw new IOException("Could not load configuration", ce);
                    }
                }
            }
            throw new IOException("Could not load configuration from " + request.getRequestLine().getUri() + " (" + response.getStatusLine().getStatusCode() + ")");
        }
    }
}

