/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.jdbi;

import com.nesscomputing.jdbi.StatementLocation;
import com.nesscomputing.jdbi.template.TemplateGroupLoader;
import com.nesscomputing.logging.Log;
import org.antlr.stringtemplate.StringTemplate;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.StatementLocator;

public class AnnotatedStatementLocator
implements StatementLocator {
    public static final String STATEMENT_CLASS = "_jmx_class";
    public static final String STATEMENT_GROUP = "_jmx_group";
    public static final String STATEMENT_NAME = "_jmx_name";
    private static final Log LOG = Log.findLog();
    private final String markerString;
    private final StatementLocator defaultLocator;
    private final SqlLocator defaultSqlLocator;
    private final String defaultClassName;

    public AnnotatedStatementLocator(Object annotatedObject) {
        this(annotatedObject.getClass(), null);
    }

    public AnnotatedStatementLocator(Object annotatedObject, StatementLocator defaultLocator) {
        this(annotatedObject.getClass(), defaultLocator, "@");
    }

    public AnnotatedStatementLocator(Object annotatedObject, StatementLocator defaultLocator, String markerString) {
        this(annotatedObject.getClass(), defaultLocator, markerString);
    }

    public AnnotatedStatementLocator(Class<?> annotatedClass) {
        this(annotatedClass, null);
    }

    public AnnotatedStatementLocator(Class<?> annotatedClass, StatementLocator defaultLocator) {
        this(annotatedClass, defaultLocator, "@");
    }

    public AnnotatedStatementLocator(Class<?> annotatedClass, StatementLocator defaultLocator, String markerString) {
        this.defaultLocator = defaultLocator;
        this.markerString = markerString;
        this.defaultClassName = annotatedClass.getName();
        this.defaultSqlLocator = new SqlLocator(annotatedClass);
    }

    public String locate(String statementName, StatementContext context) throws Exception {
        if (StringUtils.isEmpty((CharSequence)statementName)) {
            throw new IllegalStateException("Statement Name can not be empty/null!");
        }
        if (statementName.startsWith(this.markerString)) {
            return this.defaultSqlLocator.getTemplate(statementName.substring(this.markerString.length()), context);
        }
        String[] fieldElements = StringUtils.split((String)statementName, (char)':');
        if (fieldElements.length != 2 || !fieldElements[1].startsWith(this.markerString)) {
            return this.defaultLocate(statementName, context);
        }
        if (this.defaultClassName.equals(fieldElements[0])) {
            return this.defaultSqlLocator.getTemplate(fieldElements[1].substring(this.markerString.length()), context);
        }
        try {
            SqlLocator sqlLocator = new SqlLocator(Class.forName(fieldElements[0]));
            return sqlLocator.getTemplate(fieldElements[1].substring(this.markerString.length()), context);
        }
        catch (ClassNotFoundException cnfe) {
            LOG.trace((Throwable)cnfe, "Ignoring, falling back to default locator");
        }
        catch (IllegalArgumentException ex) {
            LOG.trace((Throwable)ex, "Ignoring, falling back to default locator");
        }
        return this.defaultLocate(statementName, context);
    }

    protected String defaultLocate(String pathOrSql, StatementContext context) throws Exception {
        if (this.defaultLocator == null) {
            return pathOrSql;
        }
        return this.defaultLocator.locate(pathOrSql, context);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.defaultSqlLocator.groupName).append((Object)this.markerString).append((Object)this.defaultLocator).toString();
    }

    private final class SqlLocator {
        private final StringTemplateGroup templateGroup;
        private final String groupName;
        private final String className;

        private SqlLocator(Class<?> clazz) {
            this.className = clazz.getName();
            StatementLocation location = clazz.getAnnotation(StatementLocation.class);
            if (location == null) {
                throw new IllegalArgumentException(clazz.getName() + " is missing the @StatementLocator annotation!");
            }
            String sqlFile = "/" + (StringUtils.isNotEmpty((CharSequence)location.value()) ? location.value() : "sql.st");
            String sqlPackage = clazz.getPackage().getName();
            this.groupName = sqlPackage + sqlFile;
            this.templateGroup = TemplateGroupLoader.load(sqlPackage, sqlFile);
            LOG.trace("Loading templates from %s!", new Object[]{this.groupName});
        }

        public String getTemplate(String statementName, StatementContext context) throws Exception {
            StringTemplate template;
            try {
                template = this.templateGroup.getInstanceOf(statementName);
            }
            catch (IllegalArgumentException ex) {
                LOG.info("Didn't find a template when expected: %s: %s", new Object[]{this.groupName, statementName});
                return AnnotatedStatementLocator.this.defaultLocate(statementName, context);
            }
            context.setAttribute(AnnotatedStatementLocator.STATEMENT_CLASS, (Object)this.className);
            context.setAttribute(AnnotatedStatementLocator.STATEMENT_GROUP, (Object)this.groupName);
            context.setAttribute(AnnotatedStatementLocator.STATEMENT_NAME, (Object)statementName);
            template.setAttributes(context.getAttributes());
            String sql = template.toString();
            LOG.trace("SQL for %s: %s", new Object[]{this.groupName, sql});
            return sql;
        }
    }
}

