/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.jdbi;

import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URI;
import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public final class JdbiMappers {
    private JdbiMappers() {
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public static Boolean getBoolean(ResultSet rs, String columnName) throws SQLException {
        boolean res = rs.getBoolean(columnName);
        if (rs.wasNull()) {
            return null;
        }
        return res;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
    public static Boolean getBoolean(ResultSet rs, int columnIndex) throws SQLException {
        boolean res = rs.getBoolean(columnIndex);
        if (rs.wasNull()) {
            return null;
        }
        return res;
    }

    public static DateTime getDateTime(ResultSet rs, String columnName) throws SQLException {
        Timestamp ts = rs.getTimestamp(columnName);
        return ts == null ? null : new DateTime((Object)ts);
    }

    public static DateTime getDateTime(ResultSet rs, int columnIndex) throws SQLException {
        Timestamp ts = rs.getTimestamp(columnIndex);
        return ts == null ? null : new DateTime((Object)ts);
    }

    public static DateTime getUTCDateTime(ResultSet rs, String columnName) throws SQLException {
        Timestamp ts = rs.getTimestamp(columnName);
        return ts == null ? null : new DateTime((Object)ts).withZone(DateTimeZone.UTC);
    }

    public static DateTime getUTCDateTime(ResultSet rs, int columnIndex) throws SQLException {
        Timestamp ts = rs.getTimestamp(columnIndex);
        return ts == null ? null : new DateTime((Object)ts).withZone(DateTimeZone.UTC);
    }

    public static <T extends Enum<T>> T getEnum(ResultSet rs, Class<T> enumType, String columnName) throws SQLException {
        String str = rs.getString(columnName);
        return str == null ? null : (T)Enum.valueOf(enumType, str);
    }

    public static <T extends Enum<T>> T getEnum(ResultSet rs, Class<T> enumType, int columnIndex) throws SQLException {
        String str = rs.getString(columnIndex);
        return str == null ? null : (T)Enum.valueOf(enumType, str);
    }

    public static URI getURI(ResultSet rs, String columnName) throws SQLException {
        String str = rs.getString(columnName);
        return str == null ? null : URI.create(str);
    }

    public static URI getURI(ResultSet rs, int columnIndex) throws SQLException {
        String str = rs.getString(columnIndex);
        return str == null ? null : URI.create(str);
    }

    public static List<String> getStringList(ResultSet rs, String columnName) throws SQLException {
        Array ary = rs.getArray(columnName);
        if (ary != null) {
            Preconditions.checkArgument((ary.getBaseType() == 12 || ary.getBaseType() == 1 ? 1 : 0) != 0);
            return Arrays.asList((String[])ary.getArray());
        }
        return null;
    }

    public static List<String> getStringList(ResultSet rs, int columnIndex) throws SQLException {
        Array ary = rs.getArray(columnIndex);
        if (ary != null) {
            Preconditions.checkArgument((ary.getBaseType() == 12 || ary.getBaseType() == 1 ? 1 : 0) != 0);
            return Arrays.asList((String[])ary.getArray());
        }
        return null;
    }

    public static List<Integer> getIntegerList(ResultSet rs, String columnName) throws SQLException {
        Array ary = rs.getArray(columnName);
        if (ary != null) {
            Preconditions.checkArgument((ary.getBaseType() == 4 || ary.getBaseType() == 5 ? 1 : 0) != 0);
            return Arrays.asList((Integer[])ary.getArray());
        }
        return null;
    }

    public static List<Integer> getIntegerList(ResultSet rs, int columnIndex) throws SQLException {
        Array ary = rs.getArray(columnIndex);
        if (ary != null) {
            Preconditions.checkArgument((ary.getBaseType() == 4 || ary.getBaseType() == 5 ? 1 : 0) != 0);
            return Arrays.asList((Integer[])ary.getArray());
        }
        return null;
    }

    public static List<Long> getLongList(ResultSet rs, String columnName) throws SQLException {
        Array ary = rs.getArray(columnName);
        if (ary != null) {
            Preconditions.checkArgument((ary.getBaseType() == -5 ? 1 : 0) != 0);
            return Arrays.asList((Long[])ary.getArray());
        }
        return null;
    }

    public static List<Long> getLongList(ResultSet rs, int columnIndex) throws SQLException {
        Array ary = rs.getArray(columnIndex);
        if (ary != null) {
            Preconditions.checkArgument((ary.getBaseType() == -5 ? 1 : 0) != 0);
            return Arrays.asList((Long[])ary.getArray());
        }
        return null;
    }
}

