/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.jdbi;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.security.ProviderException;
import org.skife.jdbi.v2.IDBI;

public final class SqlObjectBinder {
    private SqlObjectBinder() {
    }

    public static <T> void bindSqlObjectOnDemand(Binder binder, Class<T> sqlObjectClass, String dbName) {
        SqlObjectBinder.bindSqlObjectOnDemand(binder, sqlObjectClass, (Annotation)Names.named((String)dbName));
    }

    public static <T> void bindSqlObjectOnDemand(Binder binder, Class<T> sqlObjectClass, Annotation annotation) {
        binder.bind(sqlObjectClass).toProvider(new SqlObjectProvider(sqlObjectClass, annotation, Style.ON_DEMAND)).in(Scopes.SINGLETON);
    }

    public static <T> void bindSqlObjectOpen(Binder binder, Class<T> sqlObjectClass, String dbName) {
        SqlObjectBinder.bindSqlObjectOnDemand(binder, sqlObjectClass, (Annotation)Names.named((String)dbName));
    }

    public static <T> void bindSqlObjectOpen(Binder binder, Class<T> sqlObjectClass, Annotation annotation) {
        binder.bind(sqlObjectClass).toProvider(new SqlObjectProvider(sqlObjectClass, annotation, Style.OPEN)).in(Scopes.SINGLETON);
    }

    static class SqlObjectProvider<T>
    implements Provider<T> {
        private final Class<? extends T> sqlObjectClass;
        private final Annotation annotation;
        private final Style style;
        private IDBI idbi = null;

        private SqlObjectProvider(Class<? extends T> sqlObjectClass, Annotation annotation, Style style) {
            this.sqlObjectClass = sqlObjectClass;
            this.annotation = annotation;
            this.style = style;
        }

        @Inject
        void setInjector(Injector injector) {
            this.idbi = (IDBI)injector.getInstance(Key.get(IDBI.class, (Annotation)this.annotation));
        }

        public T get() {
            switch (this.style) {
                case ON_DEMAND: {
                    return (T)this.idbi.onDemand(this.sqlObjectClass);
                }
                case OPEN: {
                    return (T)this.idbi.open(this.sqlObjectClass);
                }
            }
            throw new ProviderException(String.format("Unknown provider style: %s", new Object[]{this.style}));
        }
    }

    private static enum Style {
        ON_DEMAND,
        OPEN;

    }
}

