/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.jdbi.argument;

import com.nesscomputing.jdbi.argument.DateTimeArgument;
import com.nesscomputing.jdbi.argument.SqlArrayArgument;
import com.nesscomputing.jdbi.argument.URIArgument;
import java.net.URI;
import java.sql.Array;
import org.joda.time.ReadableInstant;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;
import org.skife.jdbi.v2.tweak.ArgumentFactory;

final class ArgumentFactories {
    private ArgumentFactories() {
    }

    static final class ArgumentArgumentFactory
    implements ArgumentFactory<Argument> {
        ArgumentArgumentFactory() {
        }

        public boolean accepts(Class<?> expectedType, Object value, StatementContext ctx) {
            return value instanceof Argument;
        }

        public Argument build(Class<?> expectedType, Argument value, StatementContext ctx) {
            return value;
        }
    }

    static final class SqlArrayArgumentFactory
    implements ArgumentFactory<Array> {
        SqlArrayArgumentFactory() {
        }

        public boolean accepts(Class<?> expectedType, Object value, StatementContext ctx) {
            return value instanceof Array;
        }

        public Argument build(Class<?> expectedType, Array value, StatementContext ctx) {
            return new SqlArrayArgument(value);
        }
    }

    static final class DateTimeArgumentFactory
    implements ArgumentFactory<ReadableInstant> {
        DateTimeArgumentFactory() {
        }

        public boolean accepts(Class<?> expectedType, Object value, StatementContext ctx) {
            return value instanceof ReadableInstant;
        }

        public Argument build(Class<?> expectedType, ReadableInstant value, StatementContext ctx) {
            return new DateTimeArgument(value);
        }
    }

    static final class UriArgumentFactory
    implements ArgumentFactory<URI> {
        UriArgumentFactory() {
        }

        public boolean accepts(Class<?> expectedType, Object value, StatementContext ctx) {
            return value instanceof URI;
        }

        public Argument build(Class<?> expectedType, URI value, StatementContext ctx) {
            return new URIArgument(value);
        }
    }
}

