/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.jdbi.argument;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;

public class CollectionArgument<T>
implements Argument {
    private static final Map<Integer, String> SQL_TYPES = ImmutableMap.of((Object)-5, (Object)"bigint", (Object)4, (Object)"int", (Object)12, (Object)"varchar");
    private final Collection<? extends T> collection;
    private final int sqlType;
    private final String type;

    CollectionArgument(Collection<? extends T> collection, int sqlType) {
        this.collection = collection;
        this.sqlType = sqlType;
        this.type = SQL_TYPES.get(sqlType);
        Preconditions.checkArgument((this.type != null ? 1 : 0) != 0, (Object)("No string type for " + sqlType + " found!"));
    }

    CollectionArgument(Collection<? extends T> collection, String type) {
        this.collection = collection;
        this.sqlType = 1111;
        this.type = type;
    }

    public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
        if (this.collection == null) {
            statement.setNull(position, this.sqlType);
        } else if (statement.getConnection().getMetaData().getDatabaseProductName().equalsIgnoreCase("h2")) {
            statement.setObject(position, this.collection.toArray());
        } else {
            Array sqlArray = ctx.getConnection().createArrayOf(this.type, this.collection.toArray());
            statement.setArray(position, sqlArray);
        }
    }

    public String toString() {
        return this.collection == null ? "<null>" : this.collection.toString();
    }
}

