/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.jdbi.argument;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.joda.time.ReadableInstant;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;

public class DateTimeArgument
implements Argument {
    private final ReadableInstant dateTime;

    DateTimeArgument(ReadableInstant dateTime) {
        this.dateTime = dateTime;
    }

    public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
        if (this.dateTime == null) {
            statement.setNull(position, 93);
        } else {
            long millis = this.dateTime.getMillis();
            statement.setTimestamp(position, new Timestamp(millis));
        }
    }

    public String toString() {
        return String.valueOf(this.dateTime);
    }
}

