/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.jdbi.argument;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;

public class EnumArgument<T extends Enum<T>>
implements Argument {
    private final Enum<T> enumValue;

    EnumArgument(Enum<T> enumValue) {
        this.enumValue = enumValue;
    }

    public static <X extends Enum<X>> EnumArgument<X> from(X enumValue) {
        return new EnumArgument(enumValue);
    }

    public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
        if (this.enumValue == null) {
            statement.setNull(position, 0);
        } else {
            statement.setString(position, this.enumValue.toString());
        }
    }

    public String toString() {
        return this.enumValue.toString();
    }
}

