/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.jdbi.argument;

import com.google.common.base.Preconditions;
import com.nesscomputing.jdbi.argument.CollectionArgument;
import com.nesscomputing.jdbi.argument.EnumArgument;
import java.util.Collection;
import java.util.UUID;

public final class JdbiArguments {
    private JdbiArguments() {
    }

    public static <U extends Enum<U>> EnumArgument<U> forEnum(Enum<U> enumValue) {
        return new EnumArgument<U>(enumValue);
    }

    public static CollectionArgument<String> forStringCollection(Collection<String> collection) {
        return new CollectionArgument<String>(collection, 12);
    }

    public static CollectionArgument<Integer> forIntCollection(Collection<Integer> collection) {
        return new CollectionArgument<Integer>(collection, 4);
    }

    public static CollectionArgument<Long> forLongCollection(Collection<Long> collection) {
        return new CollectionArgument<Long>(collection, -5);
    }

    public static <T> CollectionArgument<T> forObjectCollection(Collection<? extends T> collection, String type) {
        return new CollectionArgument<T>(collection, type);
    }

    public static <T> CollectionArgument<T> forObjectCollection(Collection<? extends T> collection) {
        Preconditions.checkArgument((!collection.isEmpty() ? 1 : 0) != 0, (Object)"Empty collections are not supported.");
        T object = collection.iterator().next();
        if (object instanceof String) {
            return JdbiArguments.forStringCollection(collection);
        }
        if (object instanceof Long) {
            return JdbiArguments.forLongCollection(collection);
        }
        if (object instanceof Integer) {
            return JdbiArguments.forIntCollection(collection);
        }
        if (object instanceof UUID) {
            return JdbiArguments.forObjectCollection(collection, "uuid");
        }
        throw new IllegalArgumentException(String.format("Unsupported type of collection: %s", object.getClass()));
    }
}

