/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.jdbi.argument;

import java.sql.Array;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.Argument;

public class SqlArrayArgument
implements Argument {
    private final Array sqlArray;

    SqlArrayArgument(Array sqlArray) {
        this.sqlArray = sqlArray;
    }

    public void apply(int position, PreparedStatement statement, StatementContext ctx) throws SQLException {
        if (this.sqlArray == null) {
            statement.setNull(position, 12);
        } else {
            statement.setArray(position, this.sqlArray);
        }
    }

    public String toString() {
        return this.sqlArray == null ? "<null>" : this.sqlArray.toString();
    }
}

