/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.jdbi.mapper;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public abstract class PrefixResultSetMapper<T>
implements ResultSetMapper<T> {
    private final String prefix;
    private final Map<String, String> fieldNameCache = new ConcurrentHashMap<String, String>();

    protected PrefixResultSetMapper(String prefix) {
        this.prefix = StringUtils.isBlank((CharSequence)prefix) ? null : prefix;
    }

    protected String buildName(String fieldName) {
        if (this.prefix == null) {
            return fieldName;
        }
        if (this.fieldNameCache.containsKey(fieldName)) {
            return this.fieldNameCache.get(fieldName);
        }
        String result = this.prefix + fieldName;
        this.fieldNameCache.put(fieldName, result);
        return result;
    }
}

