/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.jdbi.metrics;

import com.google.common.base.Objects;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.name.Named;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.jdbi.InstrumentedTimingCollector;
import com.yammer.metrics.jdbi.strategies.ShortNameStrategy;
import com.yammer.metrics.jdbi.strategies.StatementNameStrategy;
import java.util.concurrent.TimeUnit;
import org.skife.jdbi.v2.TimingCollector;

public class DatabaseMetricsModule
extends AbstractModule {
    protected void configure() {
        this.bind(StatementNameStrategy.class).toInstance((Object)new ShortNameStrategy("ness.jdbi.metrics"));
        this.bind(TimingCollector.class).toProvider(TimingCollectorProvider.class).in(Scopes.SINGLETON);
    }

    static class TimingCollectorProvider
    implements Provider<TimingCollector> {
        private final MetricsRegistry metricsRegistry;
        private final StatementNameStrategy statementNameStrategy;
        private TimeUnit durationUnit = TimeUnit.MILLISECONDS;
        private TimeUnit rateUnit = TimeUnit.SECONDS;

        @Inject
        public TimingCollectorProvider(MetricsRegistry metricsRegistry, StatementNameStrategy statementNameStrategy) {
            this.metricsRegistry = metricsRegistry;
            this.statementNameStrategy = statementNameStrategy;
        }

        @Inject(optional=true)
        void setDurationUnit(@Named(value="MetricsTimingCollector.durationUnit") TimeUnit durationUnit) {
            this.durationUnit = (TimeUnit)((Object)Objects.firstNonNull((Object)((Object)durationUnit), (Object)((Object)this.durationUnit)));
        }

        @Inject(optional=true)
        void setRateUnit(@Named(value="MetricsTimingCollector.rateUnit") TimeUnit rateUnit) {
            this.rateUnit = (TimeUnit)((Object)Objects.firstNonNull((Object)((Object)rateUnit), (Object)((Object)this.rateUnit)));
        }

        public TimingCollector get() {
            return new InstrumentedTimingCollector(this.metricsRegistry, this.statementNameStrategy, this.durationUnit, this.rateUnit);
        }
    }
}

