/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.jdbi.template;

import com.nesscomputing.jdbi.template.TemplateLoaderException;
import com.nesscomputing.logging.Log;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.antlr.stringtemplate.StringTemplateErrorListener;
import org.antlr.stringtemplate.StringTemplateGroup;
import org.antlr.stringtemplate.language.AngleBracketTemplateLexer;

public class TemplateGroupLoader {
    private static final Log LOG = Log.findLog();

    public static StringTemplateGroup load(String name) {
        URL resourceUrl = TemplateGroupLoader.class.getClassLoader().getResource(name);
        if (resourceUrl == null) {
            throw new TemplateLoaderException("Error loading StringTemplate: Resource %s does not exist!", name);
        }
        return TemplateGroupLoader.load(name, resourceUrl);
    }

    public static List<StringTemplateGroup> loadAll(String name) {
        try {
            Enumeration<URL> resourceUrls = TemplateGroupLoader.class.getClassLoader().getResources(name);
            ArrayList<StringTemplateGroup> groups = new ArrayList<StringTemplateGroup>();
            while (resourceUrls.hasMoreElements()) {
                groups.add(TemplateGroupLoader.load(name, resourceUrls.nextElement()));
            }
            return groups;
        }
        catch (IOException ex) {
            throw new TemplateLoaderException(ex, "Error loading StringTemplate: %s", name);
        }
    }

    public static StringTemplateGroup load(String name, URL resourceUrl) {
        InputStreamReader reader;
        if (resourceUrl == null) {
            throw new TemplateLoaderException("Error loading StringTemplate: Resource %s does not exist!", name);
        }
        try {
            reader = new InputStreamReader(resourceUrl.openStream(), Charset.forName("UTF-8"));
        }
        catch (IOException ex) {
            throw new TemplateLoaderException(ex, "Error loading StringTemplate: %s", name);
        }
        final AtomicBoolean error = new AtomicBoolean(false);
        StringTemplateGroup result = new StringTemplateGroup((Reader)reader, AngleBracketTemplateLexer.class, new StringTemplateErrorListener(){

            public void error(String msg, Throwable e) {
                LOG.error(e, msg);
                error.set(true);
            }

            public void warning(String msg) {
                LOG.warn(msg);
            }
        });
        if (error.get()) {
            throw new TemplateLoaderException("Error loading StringTemplate: %s", name);
        }
        return result;
    }

    public static StringTemplateGroup load(String namespace, String name) {
        return TemplateGroupLoader.load(namespace.replace(".", "/") + name);
    }

    public static List<StringTemplateGroup> loadAll(String namespace, String name) {
        return TemplateGroupLoader.loadAll(namespace.replace(".", "/") + name);
    }

    public static StringTemplateGroup load(Class<?> classObj, String name) {
        return TemplateGroupLoader.load(classObj.getPackage().getName(), name);
    }

    public static List<StringTemplateGroup> loadAll(Class<?> classObj, String name) {
        return TemplateGroupLoader.loadAll(classObj.getPackage().getName(), name);
    }
}

