/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.log4j;

import com.nesscomputing.logging.Log;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.LogManager;
import org.apache.log4j.helpers.Loader;
import org.apache.log4j.xml.DOMConfigurator;

public final class ConfigureStandaloneLogging {
    public static final String LOGGING_FORMAT = "/config/log4j-%s.xml";
    private static final String[] LOGGING_DEFAULTS = new String[]{"/config/log4j.xml", "/log4j.xml"};

    private ConfigureStandaloneLogging() {
    }

    public static URL configure() {
        return ConfigureStandaloneLogging.configure("standalone");
    }

    public static URL configure(String configurationName) {
        String log4jConfig = System.getProperty("log4j.configuration");
        if (log4jConfig != null) {
            try {
                return new URL(log4jConfig);
            }
            catch (MalformedURLException mue) {
                return Loader.getResource((String)log4jConfig);
            }
        }
        URL configFile = ConfigureStandaloneLogging.doConfigure(configurationName);
        LogManager.resetConfiguration();
        if (configFile != null) {
            DOMConfigurator.configure((URL)configFile);
            Log log = Log.findLog();
            log.info("Configured Logging for '%s', loading '%s'", configurationName, configFile);
        } else {
            BasicConfigurator.configure();
            Log log = Log.findLog();
            log.warn("Could not configure Logging for '%s', falling back to default!", configurationName == null ? "<unknown>" : configurationName);
        }
        return configFile;
    }

    private static URL doConfigure(String configurationName) {
        String loggingDefault;
        URL configFile = null;
        if (configurationName != null && (configFile = ConfigureStandaloneLogging.class.getResource(String.format(LOGGING_FORMAT, configurationName))) != null) {
            return configFile;
        }
        String[] arr$ = LOGGING_DEFAULTS;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (configFile = ConfigureStandaloneLogging.class.getResource(loggingDefault = arr$[i$])) == null; ++i$) {
        }
        return configFile;
    }
}

