/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.log4j;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.nesscomputing.syslog4j.Syslog;
import com.nesscomputing.syslog4j.SyslogConfigIF;
import com.nesscomputing.syslog4j.SyslogFacility;
import com.nesscomputing.syslog4j.SyslogIF;
import com.nesscomputing.syslog4j.SyslogLevel;
import com.nesscomputing.syslog4j.SyslogMessageIF;
import com.nesscomputing.syslog4j.SyslogMessageProcessorIF;
import com.nesscomputing.syslog4j.impl.message.processor.structured.StructuredSyslogMessageProcessor;
import com.nesscomputing.syslog4j.impl.message.structured.StructuredSyslogMessage;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

public class StructuredSyslogAppender
extends AppenderSkeleton {
    private final AtomicReference<SyslogIF> syslogHolder = new AtomicReference();
    private SyslogFacility facility = SyslogFacility.local0;
    private String protocol = "udp";
    private String syslogHost = "localhost";
    private Charset charset = Charsets.UTF_8;
    private String hostname = "no-host-name";
    private String appname = "no-app-name";
    private String ianaIdentifier = "s@0";
    private String serviceId = null;
    private String serviceConfiguration = null;
    private int syslogPort = 514;
    private int maxMessageLength = 1023;

    public boolean requiresLayout() {
        return false;
    }

    protected void append(LoggingEvent event) {
        SyslogIF syslog = this.getSyslog();
        SyslogLevel level = SyslogLevel.forValue((int)event.getLevel().getSyslogEquivalent());
        String messageId = UUID.randomUUID().toString().replace("-", "");
        String[] messageLines = StringUtils.split((String)(this.layout != null ? this.layout.format(event) : event.getRenderedMessage()), (String)"\n\r");
        for (int i = 0; i < messageLines.length; ++i) {
            Object trackToken;
            ImmutableMap.Builder b = ImmutableMap.builder();
            b.put((Object)"l", (Object)event.getLoggerName());
            b.put((Object)"c", (Object)Integer.toString(i));
            if (this.serviceId != null) {
                b.put((Object)"si", (Object)this.serviceId);
            }
            if (this.serviceConfiguration != null) {
                b.put((Object)"sc", (Object)this.serviceConfiguration);
            }
            if ((trackToken = event.getMDC("track")) != null) {
                b.put((Object)"t", (Object)trackToken.toString());
            }
            ImmutableMap payload = b.build();
            String threadName = StringUtils.replaceChars((String)event.getThreadName(), (String)" \t", (String)"");
            StructuredSyslogMessage structuredMessage = new StructuredSyslogMessage(messageId, threadName, (Map)ImmutableMap.of((Object)this.ianaIdentifier, (Object)payload), messageLines[i]);
            syslog.log(level, (SyslogMessageIF)structuredMessage);
        }
    }

    public void close() {
        SyslogIF syslog = this.getSyslog();
        syslog.flush();
    }

    private SyslogIF getSyslog() {
        SyslogIF syslog = this.syslogHolder.get();
        if (syslog == null) {
            syslog = Syslog.getInstance((String)this.protocol);
            Preconditions.checkState((syslog != null ? 1 : 0) != 0, (String)"No syslog for protocol '%s' found!", (Object[])new Object[]{this.protocol});
            SyslogConfigIF config = syslog.getConfig();
            config.setUseStructuredData(true);
            config.setTruncateMessage(true);
            config.setMaxMessageLength(this.maxMessageLength);
            config.setCharSet(this.charset);
            config.setFacility(this.facility);
            config.setHost(this.syslogHost);
            config.setPort(this.syslogPort);
            config.setIdent("");
            config.setLocalName(this.hostname);
            StructuredSyslogMessageProcessor messageProcessor = new StructuredSyslogMessageProcessor(this.appname);
            syslog.setStructuredMessageProcessor((SyslogMessageProcessorIF)messageProcessor);
            if (!this.syslogHolder.compareAndSet(null, syslog)) {
                syslog = this.syslogHolder.get();
            }
        }
        return syslog;
    }

    public void setCharset(String charsetName) {
        this.charset = Charset.forName(charsetName);
    }

    public void setMaxMessageLength(int maxMessageLength) {
        this.maxMessageLength = maxMessageLength;
    }

    public void setFacility(String facilityName) {
        SyslogFacility facility = SyslogFacility.forName((String)facilityName);
        Preconditions.checkArgument((facility != null ? 1 : 0) != 0, (String)"Facility '%s' is unknown!", (Object[])new Object[]{facilityName});
        this.facility = facility;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setSyslogHost(String syslogHost) {
        this.syslogHost = syslogHost;
    }

    public void setSyslogPort(int syslogPort) {
        this.syslogPort = syslogPort;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setAppname(String appname) {
        this.appname = appname;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public void setServiceConfiguration(String serviceConfiguration) {
        this.serviceConfiguration = serviceConfiguration;
    }

    public void setIanaIdentifier(int ianaIdentifier) {
        this.ianaIdentifier = "s@" + Integer.toString(ianaIdentifier);
    }

    public String getFacility() {
        return this.facility.name();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getSyslogHost() {
        return this.syslogHost;
    }

    public String getCharset() {
        return this.charset.name();
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getAppname() {
        return this.appname;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getServiceConfiguration() {
        return this.serviceConfiguration;
    }

    public int getSyslogPort() {
        return this.syslogPort;
    }

    public int getMaxMessageLength() {
        return this.maxMessageLength;
    }

    public int getIanaIdentifier() {
        return Integer.parseInt(this.ianaIdentifier.substring(2));
    }
}

