/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.mojo.numbers;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.nesscomputing.mojo.numbers.DateField;
import com.nesscomputing.mojo.numbers.MacroField;
import com.nesscomputing.mojo.numbers.NumberField;
import com.nesscomputing.mojo.numbers.PropertyCache;
import com.nesscomputing.mojo.numbers.PropertyElement;
import com.nesscomputing.mojo.numbers.PropertyField;
import com.nesscomputing.mojo.numbers.StringField;
import com.nesscomputing.mojo.numbers.beans.DateDefinition;
import com.nesscomputing.mojo.numbers.beans.IWFEnum;
import com.nesscomputing.mojo.numbers.beans.MacroDefinition;
import com.nesscomputing.mojo.numbers.beans.NumberDefinition;
import com.nesscomputing.mojo.numbers.beans.PropertyGroup;
import com.nesscomputing.mojo.numbers.beans.StringDefinition;
import com.nesscomputing.mojo.numbers.util.Log;
import com.pyx4j.log4j.MavenLogAppender;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

public abstract class AbstractNumbersMojo
extends AbstractMojo
implements Contextualizable {
    protected MavenProject project;
    protected Settings settings;
    protected File basedir;
    protected boolean skip = false;
    protected String onDuplicateProperty = "fail";
    protected String onMissingProperty = "fail";
    protected String[] activeGroups;
    protected PropertyGroup[] propertyGroups;
    protected NumberDefinition[] numbers;
    protected StringDefinition[] strings;
    protected DateDefinition[] dates;
    protected MacroDefinition[] macros;
    protected final Log LOG = Log.findLog();
    protected final PropertyCache propertyCache = new PropertyCache();
    private final Map<String, String> props = Maps.newHashMap();
    protected List<NumberField> numberFields = null;
    private PlexusContainer container = null;
    private boolean isSnapshot;

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        MavenLogAppender.startPluginLog((AbstractMojo)this);
        this.isSnapshot = this.project.getArtifact().isSnapshot();
        this.LOG.debug("Project is a %s.", this.isSnapshot ? "snapshot" : "release");
        this.LOG.trace("%s on duplicate, %s on missing", this.onDuplicateProperty, this.onMissingProperty);
        try {
            if (this.skip) {
                this.LOG.debug("Skipping execution!");
            } else {
                this.doExecute();
            }
        }
        catch (MojoExecutionException me) {
            try {
                throw me;
                catch (MojoFailureException mfe) {
                    throw mfe;
                }
                catch (Exception e) {
                    throw new MojoExecutionException("While running mojo: ", e);
                }
            }
            catch (Throwable throwable) {
                this.LOG.debug("Ended %s mojo run!", ((Object)((Object)this)).getClass().getSimpleName());
                MavenLogAppender.endPluginLog((AbstractMojo)this);
                throw throwable;
            }
        }
        this.LOG.debug("Ended %s mojo run!", ((Object)((Object)this)).getClass().getSimpleName());
        MavenLogAppender.endPluginLog((AbstractMojo)this);
    }

    public MavenProject getProject() {
        Preconditions.checkNotNull((Object)this.project);
        return this.project;
    }

    public Settings getSettings() {
        Preconditions.checkNotNull((Object)this.settings);
        return this.settings;
    }

    public File getBasedir() {
        Preconditions.checkNotNull((Object)this.basedir);
        return this.basedir;
    }

    public PlexusContainer getContainer() {
        Preconditions.checkNotNull((Object)this.container);
        return this.container;
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    protected abstract void doExecute() throws Exception;

    protected void loadPropertyElements() throws Exception {
        ArrayList propertyElements = Lists.newArrayList();
        this.numberFields = NumberField.createNumbers(this.propertyCache, this.numbers);
        propertyElements.addAll(this.numberFields);
        propertyElements.addAll(StringField.createStrings(this.propertyCache, this.strings));
        propertyElements.addAll(DateField.createDates(this.propertyCache, this.dates));
        propertyElements.addAll(MacroField.createMacros(this.propertyCache, this.macros, this));
        for (PropertyElement pe : propertyElements) {
            String value = pe.getPropertyValue();
            this.props.put(pe.getPropertyName(), value);
            if (pe.isExport()) {
                this.project.getProperties().setProperty(pe.getPropertyName(), (String)Objects.firstNonNull((Object)value, (Object)""));
                this.LOG.debug("Exporting Property name: %s, value: %s", pe.getPropertyName(), value);
                continue;
            }
            this.LOG.debug("Property name: %s, value: %s", pe.getPropertyName(), Objects.firstNonNull((Object)value, (Object)"<null>"));
        }
        HashMap propertyPairs = Maps.newHashMap();
        HashSet propertyNames = Sets.newHashSet();
        if (this.propertyGroups != null) {
            for (PropertyGroup propertyGroup : this.propertyGroups) {
                List<PropertyElement> propertyFields = PropertyField.createProperties(this.props, propertyGroup);
                propertyPairs.put(propertyGroup.getId(), Pair.of((Object)propertyGroup, propertyFields));
            }
        }
        if (this.activeGroups != null) {
            for (String activeGroup : this.activeGroups) {
                Pair propertyElement = (Pair)propertyPairs.get(activeGroup);
                Preconditions.checkState((propertyElement != null ? 1 : 0) != 0, (String)"activated group '%s' does not exist", (Object[])new Object[]{activeGroup});
                PropertyGroup propertyGroup = (PropertyGroup)propertyElement.getLeft();
                if (propertyGroup.isActiveOnRelease() && !this.isSnapshot || propertyGroup.isActiveOnSnapshot() && this.isSnapshot) {
                    for (PropertyElement pe : (List)propertyElement.getRight()) {
                        String value = pe.getPropertyValue();
                        String propertyName = pe.getPropertyName();
                        IWFEnum.checkState(propertyGroup.getOnDuplicateProperty(), !propertyNames.contains(propertyName), "property name '" + propertyName + "'");
                        propertyNames.add(propertyName);
                        this.project.getProperties().setProperty(propertyName, (String)Objects.firstNonNull((Object)value, (Object)""));
                    }
                    continue;
                }
                this.LOG.debug("Skipping property group %s: Snapshot: %b, onSnapshot: %b, onRelease: %b", activeGroup, this.isSnapshot, propertyGroup.isActiveOnSnapshot(), propertyGroup.isActiveOnRelease());
            }
        }
    }
}

