/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.mojo.numbers;

import com.google.common.collect.Lists;
import com.nesscomputing.mojo.numbers.PropertyCache;
import com.nesscomputing.mojo.numbers.PropertyElement;
import com.nesscomputing.mojo.numbers.ValueProvider;
import com.nesscomputing.mojo.numbers.beans.DateDefinition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class DateField
implements PropertyElement {
    private final DateDefinition dateDefinition;
    private final ValueProvider valueProvider;

    public static List<DateField> createDates(PropertyCache propertyCache, DateDefinition[] dateDefinitions) throws IOException {
        ArrayList result = Lists.newArrayList();
        if (!ArrayUtils.isEmpty((Object[])dateDefinitions)) {
            for (DateDefinition dateDefinition : dateDefinitions) {
                dateDefinition.check();
                ValueProvider dateValue = propertyCache.getPropertyValue(dateDefinition);
                DateField dateField = new DateField(dateDefinition, dateValue);
                result.add(dateField);
            }
        }
        return result;
    }

    public DateField(DateDefinition dateDefinition, ValueProvider valueProvider) {
        this.dateDefinition = dateDefinition;
        this.valueProvider = valueProvider;
    }

    @Override
    public String getPropertyName() {
        return this.dateDefinition.getId();
    }

    @Override
    public String getPropertyValue() {
        String format;
        DateTimeZone timeZone = this.dateDefinition.getTimezone() == null ? DateTimeZone.getDefault() : DateTimeZone.forID((String)this.dateDefinition.getTimezone());
        DateTime date = this.getDateTime(this.valueProvider.getValue(), timeZone);
        if (date == null && this.dateDefinition.getValue() != null) {
            date = new DateTime((Object)this.dateDefinition.getValue(), timeZone);
        }
        if (date == null) {
            date = new DateTime(timeZone);
        }
        if ((format = this.dateDefinition.getFormat()) == null) {
            return date.toString();
        }
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)format);
        return formatter.print((ReadableInstant)date);
    }

    private DateTime getDateTime(String value, DateTimeZone timeZone) {
        if (value == null) {
            return null;
        }
        try {
            return new DateTime(Long.parseLong(value), timeZone);
        }
        catch (NumberFormatException nfe) {
            return new DateTime((Object)value, timeZone);
        }
    }

    @Override
    public boolean isExport() {
        return this.dateDefinition.isExport();
    }

    public String toString() {
        return this.getPropertyValue();
    }
}

