/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.mojo.numbers;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.nesscomputing.mojo.numbers.AbstractNumbersMojo;
import com.nesscomputing.mojo.numbers.PropertyCache;
import com.nesscomputing.mojo.numbers.PropertyElement;
import com.nesscomputing.mojo.numbers.ValueProvider;
import com.nesscomputing.mojo.numbers.beans.MacroDefinition;
import com.nesscomputing.mojo.numbers.macros.MacroType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;

public class MacroField
implements PropertyElement {
    private final MacroDefinition macroDefinition;
    private final ValueProvider valueProvider;
    private final AbstractNumbersMojo mojo;

    public static List<MacroField> createMacros(PropertyCache propertyCache, MacroDefinition[] macroDefinitions, AbstractNumbersMojo mojo) throws IOException {
        ArrayList result = Lists.newArrayList();
        if (!ArrayUtils.isEmpty((Object[])macroDefinitions)) {
            for (MacroDefinition macroDefinition : macroDefinitions) {
                macroDefinition.check();
                ValueProvider macroValue = propertyCache.getPropertyValue(macroDefinition);
                MacroField macroField = new MacroField(macroDefinition, macroValue, mojo);
                result.add(macroField);
            }
        }
        return result;
    }

    public MacroField(MacroDefinition macroDefinition, ValueProvider valueProvider, AbstractNumbersMojo mojo) {
        this.macroDefinition = macroDefinition;
        this.valueProvider = valueProvider;
        this.mojo = mojo;
    }

    @Override
    public String getPropertyName() {
        return this.macroDefinition.getId();
    }

    @Override
    public String getPropertyValue() throws Exception {
        MacroType macroType;
        String type = this.macroDefinition.getMacroType();
        if (type != null) {
            macroType = (MacroType)MacroType.class.cast(this.mojo.getContainer().lookup(MacroType.ROLE, type));
        } else {
            String macroClassName = this.macroDefinition.getMacroClass();
            Preconditions.checkState((macroClassName != null ? 1 : 0) != 0, (String)"No definition for macro '%s' found!", (Object[])new Object[]{this.macroDefinition.getId()});
            Class<?> macroClass = Class.forName(macroClassName);
            macroType = (MacroType)MacroType.class.cast(macroClass.newInstance());
        }
        return macroType.getValue(this.macroDefinition, this.valueProvider, this.mojo);
    }

    @Override
    public boolean isExport() {
        return this.macroDefinition.isExport();
    }

    public String toString() {
        try {
            return this.getPropertyValue();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

