/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.mojo.numbers;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.nesscomputing.mojo.numbers.PropertyCache;
import com.nesscomputing.mojo.numbers.PropertyElement;
import com.nesscomputing.mojo.numbers.ValueProvider;
import com.nesscomputing.mojo.numbers.beans.NumberDefinition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class NumberField
implements PropertyElement {
    private static final Pattern MATCH_GROUPS = Pattern.compile("\\d+|[^\\d]+");
    private final NumberDefinition numberDefinition;
    private final ValueProvider valueProvider;
    private final List<String> elements = Lists.newArrayList();
    private final List<Integer> numberElements = Lists.newArrayList();

    public static List<NumberField> createNumbers(PropertyCache propertyCache, NumberDefinition[] numberDefinitions) throws IOException {
        ArrayList result = Lists.newArrayList();
        if (!ArrayUtils.isEmpty((Object[])numberDefinitions)) {
            for (NumberDefinition numberDefinition : numberDefinitions) {
                numberDefinition.check();
                ValueProvider numberValue = propertyCache.getPropertyValue(numberDefinition);
                NumberField numberField = new NumberField(numberDefinition, numberValue);
                result.add(numberField);
            }
        }
        return result;
    }

    public NumberField(NumberDefinition numberDefinition, ValueProvider valueProvider) {
        this.numberDefinition = numberDefinition;
        this.valueProvider = valueProvider;
    }

    @Override
    public String getPropertyName() {
        return this.numberDefinition.getId();
    }

    @Override
    public String getPropertyValue() {
        this.parse();
        String value = StringUtils.join(this.elements, null);
        String format = this.numberDefinition.getFormat();
        return format == null ? value : String.format(format, value);
    }

    @Override
    public boolean isExport() {
        return this.numberDefinition.isExport();
    }

    private void parse() {
        String value = this.valueProvider.getValue();
        Matcher m = MATCH_GROUPS.matcher(value);
        this.elements.clear();
        this.numberElements.clear();
        while (m.find()) {
            String matchValue = m.group();
            this.elements.add(matchValue);
            if (!this.isNumber(matchValue)) continue;
            this.numberElements.add(this.elements.size() - 1);
        }
        Preconditions.checkState((this.numberElements.size() > this.numberDefinition.getFieldNumber() ? 1 : 0) != 0, (String)"Only %d fields in %s, field %d requested.", (Object[])new Object[]{this.numberElements.size(), value, this.numberDefinition.getFieldNumber()});
    }

    private boolean isNumber(CharSequence c) {
        for (int i = 0; i < c.length(); ++i) {
            if (Character.isDigit(c.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public void increment() {
        Long value = this.getNumberValue();
        if (value != null) {
            this.setNumberValue(value + (long)this.numberDefinition.getIncrement());
        }
    }

    public void setNumberValue(Long value) {
        this.parse();
        if (!this.numberElements.isEmpty()) {
            this.elements.set(this.numberElements.get(this.numberDefinition.getFieldNumber()), value.toString());
            this.valueProvider.setValue(StringUtils.join(this.elements, null));
        }
    }

    public Long getNumberValue() {
        this.parse();
        return this.numberElements.isEmpty() ? null : new Long(this.elements.get(this.numberElements.get(this.numberDefinition.getFieldNumber())));
    }

    public String toString() {
        return this.getPropertyValue();
    }
}

