/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.mojo.numbers;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import com.nesscomputing.mojo.numbers.ValueProvider;
import com.nesscomputing.mojo.numbers.beans.AbstractDefinition;
import com.nesscomputing.mojo.numbers.beans.IWFCEnum;
import com.nesscomputing.mojo.numbers.util.Log;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class PropertyCache {
    private static final Log LOG = Log.findLog();
    private Map<File, PropertyCacheEntry> propFiles = Maps.newHashMap();
    private final Properties ephemeralProperties = new Properties();

    public ValueProvider getPropertyValue(AbstractDefinition<?> definition) throws IOException {
        Properties props = this.getProperties(definition);
        if (props == null) {
            String propName = definition.getPropertyName();
            String value = definition.getInitialValue();
            if (value != null) {
                this.ephemeralProperties.setProperty(propName, value);
            }
            return new ValueProvider.PropertyProvider(this.ephemeralProperties, propName);
        }
        return this.findCurrentValue(props, definition);
    }

    @VisibleForTesting
    ValueProvider findCurrentValue(Properties props, AbstractDefinition<?> definition) {
        String propName = definition.getPropertyName();
        boolean hasProperty = props.containsKey(propName);
        boolean createProperty = IWFCEnum.checkState(definition.getOnMissingProperty(), hasProperty, propName);
        if (hasProperty) {
            return new ValueProvider.PropertyProvider(props, propName);
        }
        if (createProperty) {
            props.setProperty(propName, definition.getInitialValue());
            return new ValueProvider.PropertyProvider(props, propName);
        }
        return ValueProvider.NULL_PROVIDER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    Properties getProperties(AbstractDefinition<?> definition) throws IOException {
        PropertyCacheEntry propertyCacheEntry;
        block5: {
            File definitionPropertyFile;
            block7: {
                Properties props;
                boolean createFile;
                File propertyFile;
                block6: {
                    block4: {
                        definitionPropertyFile = definition.getPropertyFile();
                        if (definitionPropertyFile == null) {
                            return null;
                        }
                        propertyFile = definitionPropertyFile.getCanonicalFile();
                        createFile = IWFCEnum.checkState(definition.getOnMissingFile(), propertyFile.exists(), definitionPropertyFile.getCanonicalPath());
                        propertyCacheEntry = this.propFiles.get(propertyFile);
                        if (propertyCacheEntry == null) break block4;
                        if (createFile) {
                            propertyCacheEntry.doCreate();
                        }
                        break block5;
                    }
                    props = new Properties();
                    if (propertyFile.exists()) break block6;
                    propertyCacheEntry = new PropertyCacheEntry(props, false, createFile);
                    break block5;
                }
                if (!propertyFile.isFile() || !propertyFile.canRead()) break block7;
                FileInputStream stream = null;
                try {
                    stream = new FileInputStream(propertyFile);
                    props.load(stream);
                    propertyCacheEntry = new PropertyCacheEntry(props, true, createFile);
                    this.propFiles.put(propertyFile, propertyCacheEntry);
                }
                catch (Throwable throwable) {
                    Closeables.closeQuietly(stream);
                    throw throwable;
                }
                Closeables.closeQuietly((Closeable)stream);
                break block5;
            }
            throw new IllegalStateException(String.format("Can not load %s, not a file!", definitionPropertyFile.getCanonicalPath()));
        }
        return propertyCacheEntry.getProps();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist() throws IOException {
        for (Map.Entry<File, PropertyCacheEntry> propFile : this.propFiles.entrySet()) {
            PropertyCacheEntry entry = propFile.getValue();
            File file = propFile.getKey();
            if (!entry.isExists() && !entry.isCreate()) continue;
            Preconditions.checkNotNull((Object)file, (Object)"no file defined, can not persist!");
            File oldFile = new File(file.getCanonicalPath() + ".bak");
            if (entry.isExists()) {
                Preconditions.checkState((boolean)file.exists(), (String)"File %s should exist!", (Object[])new Object[]{file.getCanonicalPath()});
                if (oldFile.exists()) {
                    Preconditions.checkState((boolean)oldFile.delete(), (String)"Could not delete '%s'", (Object[])new Object[]{file.getCanonicalPath()});
                }
            }
            File newFile = new File(file.getCanonicalPath() + ".new");
            FileOutputStream stream = null;
            try {
                stream = new FileOutputStream(newFile);
                entry.getProps().store(stream, "created by maven-numbers-plugin");
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(stream);
                throw throwable;
            }
            Closeables.closeQuietly((Closeable)stream);
            if (!file.exists()) continue;
            if (file.renameTo(oldFile)) {
                if (newFile.renameTo(file)) continue;
                LOG.warn("Could not rename '%s' to '%s'!", newFile, file);
                continue;
            }
            LOG.warn("Could not rename '%s' to '%s'!", file, oldFile);
        }
    }

    public static class PropertyCacheEntry {
        private final Properties props;
        private final boolean exists;
        private boolean create;

        PropertyCacheEntry(@Nonnull Properties props, boolean exists, boolean create) {
            Preconditions.checkNotNull((Object)props, (Object)"Properties element can not be null!");
            this.props = props;
            this.exists = exists;
            this.create = create;
        }

        public Properties getProps() {
            return this.props;
        }

        public boolean isExists() {
            return this.exists;
        }

        public boolean isCreate() {
            return this.create;
        }

        public void doCreate() {
            this.create = true;
        }

        public boolean equals(Object other) {
            if (!(other instanceof PropertyCacheEntry)) {
                return false;
            }
            PropertyCacheEntry castOther = (PropertyCacheEntry)other;
            return new EqualsBuilder().append((Object)this.props, (Object)castOther.props).append(this.exists, castOther.exists).append(this.create, castOther.create).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder().append((Object)this.props).append(this.exists).append(this.create).toHashCode();
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("props", (Object)this.props).append("exists", this.exists).append("create", this.create).toString();
        }
    }
}

