/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.mojo.numbers;

import com.google.common.collect.Lists;
import com.nesscomputing.mojo.numbers.PropertyElement;
import com.nesscomputing.mojo.numbers.beans.PropertyGroup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PropertyField
implements PropertyElement {
    private final String propertyName;
    private final String propertyValue;

    public static List<PropertyElement> createProperties(Map<String, String> props, PropertyGroup propertyGroup) throws IOException {
        ArrayList result = Lists.newArrayList();
        Iterator<String> it = propertyGroup.getPropertyNames();
        while (it.hasNext()) {
            String name = it.next();
            String value = propertyGroup.getPropertyValue(name, props);
            result.add(new PropertyField(name, value));
        }
        return result;
    }

    PropertyField(String propertyName, String propertyValue) {
        this.propertyName = propertyName;
        this.propertyValue = propertyValue;
    }

    @Override
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    public String getPropertyValue() {
        return this.propertyValue;
    }

    @Override
    public boolean isExport() {
        return true;
    }
}

