/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.mojo.numbers;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.nesscomputing.mojo.numbers.PropertyCache;
import com.nesscomputing.mojo.numbers.PropertyElement;
import com.nesscomputing.mojo.numbers.ValueProvider;
import com.nesscomputing.mojo.numbers.beans.IWFEnum;
import com.nesscomputing.mojo.numbers.beans.StringDefinition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class StringField
implements PropertyElement {
    private final StringDefinition stringDefinition;
    private final ValueProvider valueProvider;

    public static List<StringField> createStrings(PropertyCache propertyCache, StringDefinition[] stringDefinitions) throws IOException {
        ArrayList result = Lists.newArrayList();
        if (!ArrayUtils.isEmpty((Object[])stringDefinitions)) {
            for (StringDefinition stringDefinition : stringDefinitions) {
                stringDefinition.check();
                ValueProvider stringValue = propertyCache.getPropertyValue(stringDefinition);
                StringField stringField = new StringField(stringDefinition, stringValue);
                result.add(stringField);
            }
        }
        return result;
    }

    public StringField(StringDefinition stringDefinition, ValueProvider valueProvider) {
        this.stringDefinition = stringDefinition;
        this.valueProvider = valueProvider;
    }

    @Override
    public String getPropertyName() {
        return this.stringDefinition.getId();
    }

    @Override
    public String getPropertyValue() {
        ArrayList values = Lists.newArrayList();
        String propValue = this.valueProvider.getValue();
        List<String> definedValues = this.stringDefinition.getValues();
        if (propValue != null) {
            values.add(propValue);
        }
        if (definedValues != null) {
            values.addAll(definedValues);
        }
        String result = null;
        Iterator i$ = values.iterator();
        while (i$.hasNext()) {
            String value;
            result = value = (String)i$.next();
            if (StringUtils.isBlank((CharSequence)value) && !this.stringDefinition.isBlankIsValid()) continue;
            return (String)Objects.firstNonNull((Object)result, (Object)"");
        }
        IWFEnum.checkState(this.stringDefinition.getOnMissingValue(), false, "value");
        String format = this.stringDefinition.getFormat();
        return format == null ? result : String.format(format, result);
    }

    @Override
    public boolean isExport() {
        return this.stringDefinition.isExport();
    }

    public String toString() {
        return this.getPropertyValue();
    }
}

