/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.mojo.numbers;

import java.util.Properties;

public interface ValueProvider {
    public static final ValueProvider NULL_PROVIDER = new NullProvider();

    public String getValue();

    public void setValue(String var1);

    public static class PropertyProvider
    implements ValueProvider {
        private final Properties props;
        private final String propertyName;

        PropertyProvider(Properties props, String propertyName) {
            this.props = props;
            this.propertyName = propertyName;
        }

        @Override
        public void setValue(String value) {
            this.props.setProperty(this.propertyName, value);
        }

        @Override
        public String getValue() {
            return this.props.getProperty(this.propertyName);
        }
    }

    public static class NullProvider
    implements ValueProvider {
        private NullProvider() {
        }

        @Override
        public void setValue(String value) {
        }

        @Override
        public String getValue() {
            return null;
        }
    }
}

