/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.mojo.numbers.beans;

import com.google.common.base.Preconditions;
import com.nesscomputing.mojo.numbers.beans.IWFCEnum;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractDefinition<T extends AbstractDefinition<T>> {
    private String id;
    private boolean skip = false;
    private boolean export = false;
    private String propertyName = null;
    private File propertyFile = null;
    private IWFCEnum onMissingFile = IWFCEnum.FAIL;
    private IWFCEnum onMissingProperty = IWFCEnum.FAIL;
    private String initialValue = null;
    private String format = null;

    protected AbstractDefinition(String id, boolean skip, boolean export, String initialValue, String propertyName, File propertyFile, IWFCEnum onMissingFile, IWFCEnum onMissingProperty, String format) {
        this.id = id;
        this.skip = skip;
        this.export = export;
        this.initialValue = initialValue;
        this.propertyName = propertyName;
        this.propertyFile = propertyFile;
        this.onMissingFile = onMissingFile;
        this.onMissingProperty = onMissingProperty;
        this.format = format;
    }

    public AbstractDefinition() {
    }

    public String getId() {
        return this.id;
    }

    public T setId(String id) {
        this.id = id;
        return (T)this;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public T setSkip(boolean skip) {
        this.skip = skip;
        return (T)this;
    }

    public String getInitialValue() {
        return this.initialValue;
    }

    public T setInitialValue(String initialValue) {
        this.initialValue = initialValue;
        return (T)this;
    }

    public boolean isExport() {
        return this.export;
    }

    public T setExport(boolean export) {
        this.export = export;
        return (T)this;
    }

    public String getPropertyName() {
        return StringUtils.isNotBlank((CharSequence)this.propertyName) ? this.propertyName : this.getId();
    }

    public T setPropertyName(String propertyName) {
        this.propertyName = propertyName;
        return (T)this;
    }

    public File getPropertyFile() {
        return this.propertyFile;
    }

    public T setPropertyFile(File propertyFile) {
        this.propertyFile = propertyFile;
        return (T)this;
    }

    public IWFCEnum getOnMissingFile() {
        return this.onMissingFile;
    }

    public T setOnMissingFile(String onMissingFile) {
        this.onMissingFile = IWFCEnum.forString(onMissingFile);
        return (T)this;
    }

    public IWFCEnum getOnMissingProperty() {
        return this.onMissingProperty;
    }

    public T setOnMissingProperty(String onMissingProperty) {
        this.onMissingProperty = IWFCEnum.forString(onMissingProperty);
        return (T)this;
    }

    public String getFormat() {
        return this.format;
    }

    public T setFormat(String format) {
        this.format = format;
        return (T)this;
    }

    public void check() {
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)this.id), (Object)"the id element must not be empty!");
    }
}

