/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.mojo.numbers.beans;

import com.google.common.base.Preconditions;
import com.nesscomputing.mojo.numbers.util.Log;
import java.util.Locale;

public enum IWFCEnum {
    IGNORE,
    WARN,
    FAIL,
    CREATE;

    private static final Log LOG;

    public static IWFCEnum forString(String value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (Object)"the value can not be null");
        return IWFCEnum.valueOf(IWFCEnum.class, value.toUpperCase(Locale.ENGLISH));
    }

    public static boolean checkState(IWFCEnum iwfc, boolean exists, String thing) {
        if (exists || iwfc == IGNORE) {
            return false;
        }
        if (iwfc == WARN) {
            LOG.warn("'%s' does not exist!", thing);
            return false;
        }
        if (iwfc == FAIL) {
            throw new IllegalStateException(String.format("'%s' does not exist!", thing));
        }
        if (iwfc == CREATE) {
            LOG.debug("'%s' does not exist, suggesting creation.", thing);
            return true;
        }
        return false;
    }

    static {
        LOG = Log.findLog();
    }
}

