/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.mojo.numbers.beans;

import com.google.common.base.Preconditions;
import com.nesscomputing.mojo.numbers.util.Log;
import java.util.Locale;

public enum IWFEnum {
    IGNORE,
    WARN,
    FAIL;

    private static final Log LOG;

    public static IWFEnum forString(String value) {
        Preconditions.checkNotNull((Object)value, (Object)"the value can not be null");
        return IWFEnum.valueOf(IWFEnum.class, value.toUpperCase(Locale.ENGLISH));
    }

    public static void checkState(IWFEnum iwf, boolean exists, String thing) {
        if (exists || iwf == IGNORE) {
            return;
        }
        if (iwf == WARN) {
            LOG.warn("'%s' does not exist!", thing);
        } else if (iwf == FAIL) {
            throw new IllegalStateException(String.format("'%s' does not exist!", thing));
        }
    }

    static {
        LOG = Log.findLog();
    }
}

