/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.mojo.numbers.beans;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.nesscomputing.mojo.numbers.beans.AbstractDefinition;
import com.nesscomputing.mojo.numbers.beans.IWFCEnum;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public class NumberDefinition
extends AbstractDefinition<NumberDefinition> {
    public static final String INITIAL_VALUE = "0";
    private int fieldNumber = 0;
    private int increment = 1;

    @VisibleForTesting
    NumberDefinition(String id, boolean skip, boolean export, String initialValue, int fieldNumber, int increment, String propertyName, File propertyFile, IWFCEnum onMissingFile, IWFCEnum onMissingProperty, String format) {
        super(id, skip, export, (String)Objects.firstNonNull((Object)initialValue, (Object)INITIAL_VALUE), propertyName, propertyFile, onMissingFile, onMissingProperty, format);
        this.fieldNumber = fieldNumber;
        this.increment = increment;
    }

    public NumberDefinition() {
        this.setInitialValue(INITIAL_VALUE);
    }

    public int getFieldNumber() {
        return this.fieldNumber;
    }

    public NumberDefinition setFieldNumber(int fieldNumber) {
        this.fieldNumber = fieldNumber;
        return this;
    }

    public int getIncrement() {
        return this.increment;
    }

    public NumberDefinition setIncrement(int increment) {
        this.increment = increment;
        return this;
    }

    @Override
    public void check() {
        super.check();
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)this.getInitialValue()), (Object)"the initial value must not be empty");
        Preconditions.checkState((this.fieldNumber >= 0 ? 1 : 0) != 0, (Object)"the field number must be >= 0");
    }
}

