/*
 * Decompiled with CFR 0.152.
 */
package com.nesscomputing.mojo.numbers.beans;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.collect.Iterators;
import com.nesscomputing.mojo.numbers.beans.IWFEnum;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.codehaus.plexus.util.StringUtils;

public class PropertyGroup {
    private String id;
    private boolean activeOnRelease = true;
    private boolean activeOnSnapshot = true;
    private IWFEnum onDuplicateProperty = IWFEnum.FAIL;
    private IWFEnum onMissingProperty = IWFEnum.FAIL;
    private Properties properties = null;

    @VisibleForTesting
    PropertyGroup(String id, boolean activeOnRelease, boolean activeOnSnapshot, IWFEnum onDuplicateProperty, IWFEnum onMissingProperty, Properties properties) {
        this();
        this.id = id;
        this.activeOnRelease = activeOnRelease;
        this.activeOnSnapshot = activeOnSnapshot;
        this.onDuplicateProperty = onDuplicateProperty;
        this.onMissingProperty = onMissingProperty;
        this.properties = properties;
    }

    public PropertyGroup() {
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean isActiveOnRelease() {
        return this.activeOnRelease;
    }

    public void setActiveOnRelease(boolean activeOnRelease) {
        this.activeOnRelease = activeOnRelease;
    }

    public boolean isActiveOnSnapshot() {
        return this.activeOnSnapshot;
    }

    public void setActiveOnSnapshot(boolean activeOnSnapshot) {
        this.activeOnSnapshot = activeOnSnapshot;
    }

    public IWFEnum getOnDuplicateProperty() {
        return this.onDuplicateProperty;
    }

    public void setOnDuplicateProperty(String onDuplicateProperty) {
        this.onDuplicateProperty = IWFEnum.forString(onDuplicateProperty);
    }

    public IWFEnum getOnMissingProperty() {
        return this.onMissingProperty;
    }

    public void setOnMissingProperty(String onMissingProperty) {
        this.onMissingProperty = IWFEnum.forString(onMissingProperty);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void check() {
    }

    public Iterator<String> getPropertyNames() {
        return Iterators.transform(this.properties.keySet().iterator(), (Function)Functions.toStringFunction());
    }

    public String getPropertyValue(String propertyName, Map<String, String> propElements) {
        String propertyValue = (String)Objects.firstNonNull((Object)this.properties.getProperty(propertyName), (Object)"");
        for (Map.Entry<String, String> entry : propElements.entrySet()) {
            String key = "#{" + entry.getKey() + "}";
            propertyValue = StringUtils.replace((String)propertyValue, (String)key, (String)entry.getValue());
        }
        String result = propertyValue.replaceAll("\\#\\{.*\\}", "");
        IWFEnum.checkState(this.getOnMissingProperty(), StringUtils.equals((String)propertyValue, (String)result), "property");
        return result;
    }
}

